/*
 * Decompiled with CFR 0.152.
 */
package vars.shared.ui;

import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.EventTopicSubscriber;
import org.mbari.util.Dispatcher;
import vars.UserAccount;
import vars.shared.ui.event.LoggingTopicSubscriber;

public class GlobalLookup {
    public static final DateFormat DATE_FORMAT_UTC;
    public static final DateFormat DATE_FORMAT_LOCAL;
    protected static final Object KEY_DISPATCHER_SELECTED_FRAME;
    protected static final Object KEY_DISPATCHER_USERACCOUNT;
    public static final String TOPIC_NONFATAL_ERROR = "vars.shared.ui.GlobalLookup-TopicNonfatalError";
    public static final String TOPIC_EXIT = "vars.shared.ui.GlobalLookup-Exit";
    public static final String TOPIC_FATAL_ERROR = "vars.shared.ui.GlobalLookup-TopicFatalError";
    public static final String TOPIC_WARNING = "vars.shared.ui.GlobalLookup-TopicWarning";
    public static final String TOPIC_USERACCOUNT = "vars.shared.ui.GlobalLookup-UserAccount";
    public static final EventTopicSubscriber LOGGING_SUBSCRIBER;
    private static File settingsDirectory;
    private static final EventTopicSubscriber userAccountSubscriber;

    public static Dispatcher getSelectedFrameDispatcher() {
        return Dispatcher.getDispatcher((Object)KEY_DISPATCHER_SELECTED_FRAME);
    }

    public static Dispatcher getUserAccountDispatcher() {
        return Dispatcher.getDispatcher((Object)KEY_DISPATCHER_USERACCOUNT);
    }

    public static File getSettingsDirectory() {
        return settingsDirectory;
    }

    static {
        File logDirectory;
        DATE_FORMAT_UTC = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        DATE_FORMAT_LOCAL = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
        KEY_DISPATCHER_SELECTED_FRAME = "vars.shared.ui.GlobalLookup-SelectedFrame";
        KEY_DISPATCHER_USERACCOUNT = TOPIC_USERACCOUNT;
        LOGGING_SUBSCRIBER = new LoggingTopicSubscriber();
        userAccountSubscriber = new EventTopicSubscriber<UserAccount>(){

            public void onEvent(String topic, UserAccount data) {
                GlobalLookup.getUserAccountDispatcher().setValueObject((Object)data);
            }
        };
        DATE_FORMAT_UTC.setTimeZone(TimeZone.getTimeZone("UTC"));
        GlobalLookup.getSelectedFrameDispatcher().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object obj = evt.getNewValue();
                if (!(obj instanceof Frame)) {
                    throw new IllegalArgumentException("Required: " + Frame.class.getName() + ", Found: " + obj.getClass().getName());
                }
            }
        });
        GlobalLookup.getUserAccountDispatcher().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object obj = evt.getNewValue();
                if (obj != null && !(obj instanceof UserAccount)) {
                    throw new IllegalArgumentException("Required: " + UserAccount.class.getName() + ", Found: " + obj.getClass().getName());
                }
            }
        });
        EventBus.subscribe((String)TOPIC_USERACCOUNT, (EventTopicSubscriber)userAccountSubscriber);
        String home = System.getProperty("user.home");
        settingsDirectory = new File(home, ".vars");
        if (!settingsDirectory.exists()) {
            settingsDirectory.mkdir();
        }
        if (!(logDirectory = new File(settingsDirectory, "logs")).exists()) {
            logDirectory.mkdir();
        }
        EventBus.subscribe((String)TOPIC_EXIT, (EventTopicSubscriber)LOGGING_SUBSCRIBER);
        EventBus.subscribe((String)TOPIC_USERACCOUNT, (EventTopicSubscriber)LOGGING_SUBSCRIBER);
        EventBus.subscribe((String)TOPIC_FATAL_ERROR, (EventTopicSubscriber)LOGGING_SUBSCRIBER);
        EventBus.subscribe((String)TOPIC_WARNING, (EventTopicSubscriber)LOGGING_SUBSCRIBER);
        EventBus.subscribe((String)TOPIC_NONFATAL_ERROR, (EventTopicSubscriber)LOGGING_SUBSCRIBER);
    }
}

