/*
 * Decompiled with CFR 0.152.
 */
package vars.shared.ui;

import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.ComboBoxModel;
import org.mbari.swing.FancyComboBox;
import org.mbari.swing.SortedComboBoxModel;
import org.mbari.text.IgnoreCaseToStringComparator;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptName;
import vars.shared.ui.ConceptChangeListener;

public class ConceptNameComboBox
extends FancyComboBox
implements ConceptChangeListener {
    public ConceptNameComboBox() {
        this.setModel((ComboBoxModel)new SortedComboBoxModel((Comparator)new IgnoreCaseToStringComparator()));
        this.setToolTipText("Select Concept by name");
    }

    public ConceptNameComboBox(String[] items) {
        this();
        this.updateModel(items);
    }

    public void addItem(ConceptName item) {
        ((SortedComboBoxModel)this.getModel()).addElement((Object)item.getName());
    }

    @Override
    public void addedConcept(Concept concept) {
        Set conceptNames = concept.getConceptNames();
        for (ConceptName cn : conceptNames) {
            this.addItem(cn);
        }
    }

    @Override
    public void addedConceptName(ConceptName conceptName) {
        this.addItem(conceptName);
    }

    public void removeEditorActionListener(ActionListener listener) {
        this.editor.removeActionListener(listener);
    }

    public void removeEditorFocusListener(FocusListener listener) {
        this.editor.getEditorComponent().removeFocusListener(listener);
    }

    public void removeItem(ConceptName item) {
        ((SortedComboBoxModel)this.getModel()).removeElement((Object)item.getName());
    }

    @Override
    public void removedConcept(Concept concept) {
        List concepts = concept.getChildConcepts();
        for (Concept c : concepts) {
            this.removedConcept(c);
        }
        Set conceptNames = concept.getConceptNames();
        for (ConceptName cn : conceptNames) {
            this.removeItem(cn);
        }
    }

    @Override
    public void removedConceptName(ConceptName conceptName) {
        this.removeItem(conceptName);
    }

    public void updateModel(String[] items) {
        ((SortedComboBoxModel)this.getModel()).setItems(Arrays.asList(items));
    }
}

