/*
 * Decompiled with CFR 0.152.
 */
package vars.shared.ui;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.query.QueryPersistenceService;
import vars.shared.ui.ConceptNameComboBox;

public class AllConceptNamesComboBox
extends ConceptNameComboBox {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final QueryPersistenceService queryPersistenceService;

    public AllConceptNamesComboBox(QueryPersistenceService queryPersistenceSerice) {
        this.queryPersistenceService = queryPersistenceSerice;
        this.updateConceptNames();
        this.setEditable(true);
        this.setMaximumRowCount(12);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                AllConceptNamesComboBox.this.getEditor().selectAll();
            }
        });
    }

    private String[] getConceptNames() {
        List conceptNameList = this.queryPersistenceService.findAllConceptNamesAsStrings();
        String[] conceptNames = conceptNameList.toArray(new String[conceptNameList.size()]);
        return conceptNames;
    }

    public void updateConceptNames() {
        this.updateModel(this.getConceptNames());
    }
}

