/*
 * Decompiled with CFR 0.152.
 */
package vars.shared.preferences;

import com.google.inject.Inject;
import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.prefs.Preferences;
import java.util.prefs.PreferencesFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.VARSException;
import vars.shared.awt.AWTUtilities;
import vars.shared.ui.GlobalStateLookup;

public class PreferencesService {
    private static final String PROP_LAST_VIDEO_CONNECTION_ID = "lastVideoConnectionID";
    private static final String PROP_AUTOCONNECT_VCR = "autoconnectVCR";
    private static final String PROP_IMAGETARGET = "imageTarget";
    private static final String PROP_IMAGETARGETMAPPING = "imageTargetMapping";
    private static final String PROP_IMAGEINTERPOLATION = "imageInterpolation";
    private static final String PROP_VCR_URL = "vcrUrl";
    private File defaultImageTarget;
    private URL defaultImageTargetMapping;
    private final PreferencesFactory preferencesFactory;
    private String hostname;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Inject
    public PreferencesService(PreferencesFactory preferencesFactory) {
        this.preferencesFactory = preferencesFactory;
        this.defaultImageTarget = new File(GlobalStateLookup.getSettingsDirectory(), "images");
        try {
            this.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            this.hostname = "localhost";
            this.log.warn("Unable to get hostname", (Throwable)ex);
        }
        try {
            this.defaultImageTarget = this.findDefaultImageTarget(this.getHostname());
            this.defaultImageTargetMapping = this.defaultImageTarget.toURI().toURL();
        }
        catch (Exception e) {
            throw new VARSException("Failed to lookup default image target", (Throwable)e);
        }
        try {
            this.defaultImageTargetMapping = this.findDefaultImageTargetMapping(this.getHostname());
        }
        catch (Exception e) {
            throw new VARSException("Failed to lookup default image target mapping", (Throwable)e);
        }
    }

    public Object findImageInterpolation(String username, String hostname) {
        Object value;
        Preferences preferences = this.hostPrefs(username, hostname);
        String key = preferences.get(PROP_IMAGEINTERPOLATION, (value = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR).toString());
        if (AWTUtilities.IMAGE_INTERPOLATION_MAP.containsKey(key)) {
            value = AWTUtilities.IMAGE_INTERPOLATION_MAP.get(key);
        }
        return value;
    }

    public File findImageTarget(String username, String hostname) {
        Preferences preferences = this.hostPrefs(username, hostname);
        File imageTarget = null;
        try {
            String value = preferences.get(PROP_IMAGETARGET, this.defaultImageTarget.getCanonicalPath());
            imageTarget = new File(value);
        }
        catch (IOException ex) {
            throw new VARSException("Failed to lookup and resolve image target", (Throwable)ex);
        }
        return imageTarget;
    }

    public URL findImageTargetMapping(String username, String hostname) {
        Preferences preferences = this.hostPrefs(username, hostname);
        URL imageTarget = null;
        try {
            String value = preferences.get(PROP_IMAGETARGETMAPPING, this.findDefaultImageTargetMapping(this.getHostname()).toExternalForm());
            imageTarget = new URL(value);
        }
        catch (MalformedURLException ex) {
            throw new VARSException("Failed to lookup and resolve image target mapping", (Throwable)ex);
        }
        return imageTarget;
    }

    public File findDefaultImageTarget(String hostname) {
        Preferences preferences = this.systemPrefs(hostname);
        File imageTarget = null;
        try {
            String value = preferences.get(PROP_IMAGETARGET, this.defaultImageTarget.getCanonicalPath());
            imageTarget = new File(value);
        }
        catch (IOException ex) {
            throw new VARSException("Failed to lookup and resolve default image target", (Throwable)ex);
        }
        return imageTarget;
    }

    public URL findDefaultImageTargetMapping(String hostname) {
        Preferences preferences = this.systemPrefs(hostname);
        URL imageTarget = null;
        try {
            String value = preferences.get(PROP_IMAGETARGETMAPPING, this.defaultImageTarget.toURI().toURL().toExternalForm());
            imageTarget = new URL(value);
        }
        catch (MalformedURLException ex) {
            throw new VARSException("Failed to lookup and resolve default image target mapping", (Throwable)ex);
        }
        return imageTarget;
    }

    public String findVcrPort(String username, String hostname) {
        String fullUrl = this.findFullVcrUrl(username, hostname);
        String[] parts = fullUrl.split(":");
        return parts.length > 1 ? parts[1] : "9000";
    }

    public String findVcrHostname(String username, String hostname) {
        String fullUrl = this.findFullVcrUrl(username, hostname);
        String[] parts = fullUrl.split(":");
        return parts.length >= 1 ? parts[0] : this.getHostname();
    }

    public String findFullVcrUrl(String username, String hostname) {
        Preferences preferences = this.hostPrefs(username, hostname);
        return preferences.get(PROP_VCR_URL, this.getHostname() + ":9000");
    }

    public String findLastVideoConnectionId(String hostname) {
        Preferences preferences = this.systemPrefs(hostname);
        return preferences.get(PROP_LAST_VIDEO_CONNECTION_ID, this.getHostname() + ":9000");
    }

    public void persistLastVideoConnectionId(String hostname, String vcrUrl) {
        Preferences preferences = this.systemPrefs(hostname);
        preferences.put(PROP_LAST_VIDEO_CONNECTION_ID, vcrUrl);
    }

    public boolean findAutoconnectVcr(String hostname) {
        Preferences preferences = this.systemPrefs(hostname);
        String autoconnect = preferences.get(PROP_AUTOCONNECT_VCR, "false");
        return autoconnect.equals("true");
    }

    public void persistAutoconnectVcr(String hostname, boolean autoconnect) {
        String a = autoconnect ? "true" : "false";
        Preferences preferences = this.systemPrefs(hostname);
        preferences.put(PROP_AUTOCONNECT_VCR, a);
    }

    public void persistImageInterpolation(String username, String hostname, Object renderingHint) {
        Preferences preferences = this.hostPrefs(username, hostname);
        if (AWTUtilities.IMAGE_INTERPOLATION_MAP.containsValue(renderingHint)) {
            preferences.put(PROP_IMAGEINTERPOLATION, renderingHint.toString());
        }
    }

    public void persistVcrUrl(String username, String hostname, String vcrhost, String vcrport) {
        Preferences preferences = this.hostPrefs(username, hostname);
        preferences.put(PROP_VCR_URL, vcrhost + ":" + vcrport);
    }

    private Preferences hostPrefs(String username, String hostname) {
        Preferences lookupPreferences = this.userPrefs(username);
        return lookupPreferences.node(hostname);
    }

    private Preferences systemPrefs(String hostname) {
        Preferences systemPreferences = this.preferencesFactory.systemRoot().node("VARS");
        return systemPreferences.node(hostname);
    }

    public void persistImageTarget(String username, String hostname, File targetDirectory) {
        Preferences preferences = this.hostPrefs(username, hostname);
        try {
            preferences.put(PROP_IMAGETARGET, targetDirectory.getCanonicalPath());
        }
        catch (IOException ex) {
            throw new VARSException("Failed to save image target to preferences");
        }
    }

    public void persistDefaultImageTargetMapping(String hostname, URL targetMappingURL) {
        Preferences preferences = this.systemPrefs(hostname);
        preferences.put(PROP_IMAGETARGETMAPPING, targetMappingURL.toExternalForm());
    }

    public void persistDefaultImageTarget(String hostname, File targetDirectory) {
        Preferences preferences = this.systemPrefs(hostname);
        try {
            preferences.put(PROP_IMAGETARGET, targetDirectory.getCanonicalPath());
        }
        catch (IOException ex) {
            throw new VARSException("Failed to save image target to preferences");
        }
    }

    public void persistImageTargetMapping(String username, String hostname, URL targetMappingURL) {
        Preferences preferences = this.hostPrefs(username, hostname);
        preferences.put(PROP_IMAGETARGETMAPPING, targetMappingURL.toExternalForm());
    }

    private Preferences userPrefs(String username) {
        Preferences userPreferences = this.preferencesFactory.systemRoot().node(username);
        String node = PreferencesService.class.getCanonicalName().replace(".", "/");
        return userPreferences.node(node);
    }

    public String getHostname() {
        return this.hostname;
    }
}

