/*
 * Decompiled with CFR 0.152.
 */
package vars.shared.javafx.stage;

import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import vars.shared.javafx.scene.image.ImageViewExt;

public class ImageStage
extends Stage {
    private ImageView imageView;
    private ImageViewExt imageViewExt;

    public ImageStage() {
        this.initialize();
    }

    public ImageStage(StageStyle style) {
        super(style);
        this.initialize();
    }

    private void initialize() {
        this.imageView = new ImageView();
        this.imageView.setPreserveRatio(true);
        this.imageView.setSmooth(true);
        this.imageView.setCache(true);
        this.imageViewExt = new ImageViewExt(this.imageView);
        BorderPane root = new BorderPane((Node)this.imageView);
        this.imageView.fitWidthProperty().bind((ObservableValue)this.widthProperty());
        this.imageView.fitHeightProperty().bind((ObservableValue)this.heightProperty());
        Scene scene = new Scene((Parent)root);
        scene.setFill((Paint)Color.BLACK);
        this.setScene(scene);
    }

    public void setImage(Image image) {
        this.imageView.setImage(image);
    }

    public BorderPane getRoot() {
        return (BorderPane)this.getScene().getRoot();
    }

    public Image getImage() {
        return this.imageView.getImage();
    }

    public double getImageScale() {
        return this.imageViewExt.computeActualScale();
    }

    public ImageView getImageView() {
        return this.imageView;
    }

    public Point2D convertToScene(Point2D imagePoint) {
        double s = this.imageViewExt.computeActualScale();
        Point2D imageViewPoint = imagePoint.multiply(s);
        return this.imageView.localToScene(imageViewPoint);
    }

    public Point2D convertToImage(Point2D scenePoint) {
        double s = this.imageViewExt.computeActualScale();
        Point2D imageViewPoint = this.imageView.sceneToLocal(scenePoint.getX(), scenePoint.getY());
        return imageViewPoint.multiply(1.0 / s);
    }
}

