/*
 * Decompiled with CFR 0.152.
 */
package vars.shared.javafx.scene.image;

import javafx.geometry.Rectangle2D;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

public class ImageViewExt {
    private final ImageView imageView;
    private double actualScale = Double.NaN;
    private boolean doScaleRecompute = true;

    public ImageViewExt(ImageView imageView) {
        this.imageView = imageView;
        imageView.imageProperty().addListener(i -> {
            this.doScaleRecompute = true;
        });
        imageView.fitHeightProperty().addListener(i -> {
            this.doScaleRecompute = true;
        });
        imageView.fitWidthProperty().addListener(i -> {
            this.doScaleRecompute = true;
        });
    }

    public double computeActualScale() {
        if (!this.imageView.isPreserveRatio()) {
            this.actualScale = Double.NaN;
        } else if (this.doScaleRecompute) {
            Image localImage = this.imageView.getImage();
            Rectangle2D localViewport = this.imageView.getViewport();
            double w = 0.0;
            double h = 0.0;
            if (localViewport != null && localViewport.getWidth() > 0.0 && localViewport.getHeight() > 0.0) {
                w = localViewport.getWidth();
                h = localViewport.getHeight();
            } else if (localImage != null) {
                w = localImage.getWidth();
                h = localImage.getHeight();
            }
            double localFitWidth = this.imageView.getFitWidth();
            double localFitHeight = this.imageView.getFitHeight();
            if (w > 0.0 && h > 0.0 && (localFitWidth > 0.0 || localFitHeight > 0.0)) {
                w = localFitWidth <= 0.0 || localFitHeight > 0.0 && localFitWidth * h > localFitHeight * w ? w * localFitHeight / h : localFitWidth;
                this.actualScale = w / localImage.getWidth();
            }
            this.doScaleRecompute = false;
        }
        return this.actualScale;
    }
}

