/*
 * Decompiled with CFR 0.152.
 */
package vars.shared.javafx.application;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.geometry.Point2D;
import javafx.scene.effect.BlendMode;
import javafx.scene.image.Image;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.shared.javafx.stage.ImageStage;

public class ImageFX {
    private static int TIMEOUT = 5000;
    private static final Logger log = LoggerFactory.getLogger(ImageFX.class);
    private static boolean isJavaFXRunning = false;
    private static final CountDownLatch launchLatch = new CountDownLatch(1);
    private static Map<String, ImageStage> namedWindows = new ConcurrentHashMap<String, ImageStage>();

    public static void setIsJavaFXRunning(boolean isJavaFXRunning) {
        ImageFX.isJavaFXRunning = isJavaFXRunning;
    }

    private static void startJavaFX() {
        if (!isJavaFXRunning) {
            new Thread(() -> {
                try {
                    Application.launch(MyApp.class, (String[])new String[]{""});
                }
                catch (Exception e) {
                    log.info("JavaFX did not launch app. A JavaFX app may already be running", (Throwable)e);
                }
            }).start();
            try {
                if (!launchLatch.await(TIMEOUT, TimeUnit.MILLISECONDS)) {
                    throw new RuntimeException("Timeout waiting for Application to launch");
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Timeout waiting for Application to launch");
            }
        }
    }

    public static CompletableFuture<ImageStage> namedWindow(String title, Image image) {
        return ImageFX.namedWindow(title, image, false);
    }

    public static CompletableFuture<ImageStage> namedWindow(String title, String imageLocation, boolean showTooltip) {
        ImageFX.startJavaFX();
        CompletableFuture<ImageStage> imageStageFuture = new CompletableFuture<ImageStage>();
        ImageFX.runOnJavaFXThread(() -> {
            try {
                Image image = new Image(imageLocation);
                CompletableFuture<ImageStage> isF = ImageFX.namedWindow(title, image, showTooltip);
                isF.thenAccept(imageStageFuture::complete);
            }
            catch (Exception e) {
                imageStageFuture.completeExceptionally(e);
                log.warn("Failed to open " + imageLocation, (Throwable)e);
            }
        });
        return imageStageFuture;
    }

    public static CompletableFuture<ImageStage> namedWindow(String title, String imageLocation) {
        return ImageFX.namedWindow(title, imageLocation, false);
    }

    public static CompletableFuture<ImageStage> namedWindow(String title, Image image, boolean showTooltip) {
        ImageFX.startJavaFX();
        CompletableFuture<ImageStage> imageStageFuture = new CompletableFuture<ImageStage>();
        ImageFX.runOnJavaFXThread(() -> {
            ImageStage stage;
            if (namedWindows.containsKey(title)) {
                stage = namedWindows.get(title);
            } else {
                stage = new ImageStage();
                namedWindows.put(title, stage);
            }
            stage.setTitle(title);
            stage.setImage(image);
            if (showTooltip) {
                BorderPane root = stage.getRoot();
                Text text = new Text("100, 100");
                text.setLayoutX(100.0);
                text.setLayoutX(100.0);
                text.setFill((Paint)Color.WHITE);
                text.setBlendMode(BlendMode.DIFFERENCE);
                root.getChildren().add((Object)text);
                root.setOnMouseMoved(e -> {
                    String msg = "";
                    Point2D scenePoint = new Point2D(e.getSceneX(), e.getSceneY());
                    Point2D imagePoint = stage.convertToImage(scenePoint);
                    msg = String.format("%.1f, %.1f", imagePoint.getX(), imagePoint.getY());
                    text.setLayoutX(e.getX());
                    text.setLayoutY(e.getY());
                    text.setText(msg);
                });
            }
            imageStageFuture.complete(stage);
        });
        return imageStageFuture;
    }

    public static Optional<ImageStage> getNamedWindow(String title) {
        return Optional.ofNullable(namedWindows.get(title));
    }

    private static void runOnJavaFXThread(Runnable r) {
        if (Platform.isFxApplicationThread()) {
            r.run();
        } else {
            Platform.runLater((Runnable)r);
        }
    }

    public static class MyApp
    extends Application {
        Stage primaryStage;

        public void init() throws Exception {
            isJavaFXRunning = true;
        }

        public void start(Stage primaryStage) throws Exception {
            primaryStage.setTitle(((Object)((Object)this)).getClass().getSimpleName());
            this.primaryStage = primaryStage;
            launchLatch.countDown();
        }

        public void stop() throws Exception {
            isJavaFXRunning = false;
            super.stop();
        }
    }
}

