/*
 * Decompiled with CFR 0.152.
 */
package vars.avplayer.kipro;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.mbari.vcr4j.kipro.QuadError;
import org.mbari.vcr4j.kipro.QuadState;
import vars.ToolBelt;
import vars.annotation.VideoArchive;
import vars.annotation.VideoArchiveDAO;
import vars.avplayer.OpenVideoArchiveDialog;
import vars.avplayer.OpenVideoArchivePanel;
import vars.avplayer.SimpleVideoParams;

public class QuadVideoPlayerDialogUI
extends OpenVideoArchiveDialog<QuadState, QuadError> {
    private JPanel topPanel;
    private JTextField hostTextField;
    public static final String PREF_HTTP_ADDRESS = "aja-kipro-quad-address";

    public QuadVideoPlayerDialogUI(Window parent, ToolBelt toolBelt) {
        super(parent, toolBelt);
        this.initialize();
        this.pack();
    }

    private void initialize() {
        this.setPreferredSize(new Dimension(475, 550));
        this.getContentPane().add((Component)this.getTopPanel(), "North");
    }

    public void setVisible(boolean b) {
        Preferences prefs = Preferences.userNodeForPackage(((Object)((Object)this)).getClass());
        String address = prefs.get(PREF_HTTP_ADDRESS, "");
        if (address != null && !address.isEmpty()) {
            this.getHostTextField().setText(address);
        }
        super.setVisible(b);
    }

    public VideoArchive openVideoArchive() {
        this.saveQuadHTTPAddress(this.getQuadHTTPAddress());
        return super.openVideoArchive();
    }

    protected VideoArchive openVideoArchiveByParams() {
        VideoArchiveDAO dao = this.getToolBelt().getAnnotationDAOFactory().newVideoArchiveDAO();
        dao.startTransaction();
        OpenVideoArchivePanel p = this.getCenterPanel();
        int sequenceNumber = Integer.parseInt(p.getSequenceNumberTextField().getText());
        String platform = (String)p.getCameraPlatformComboBox().getSelectedItem();
        int tapeNumber = Integer.parseInt(p.getTapeNumberTextField().getText());
        boolean isHd = p.getHdCheckBox().isSelected();
        SimpleVideoParams videoParams = new SimpleVideoParams(platform, Integer.valueOf(sequenceNumber), Integer.valueOf(tapeNumber), Boolean.valueOf(isHd));
        String videoArchiveName = videoParams.getVideoArchiveName();
        VideoArchive videoArchive = dao.findOrCreateByParameters(platform, sequenceNumber, videoArchiveName);
        dao.endTransaction();
        return videoArchive;
    }

    public JTextField getHostTextField() {
        if (this.hostTextField == null) {
            this.hostTextField = new JTextField();
            this.hostTextField.setColumns(10);
        }
        return this.hostTextField;
    }

    public JPanel getTopPanel() {
        if (this.topPanel == null) {
            this.topPanel = new JPanel();
            BoxLayout layout = new BoxLayout(this.topPanel, 0);
            this.topPanel.setLayout(layout);
            this.topPanel.setBorder(new TitledBorder(null, "KiPro Quad Remote Address", 4, 2, null, null));
            this.topPanel.add(new JLabel("IP Address:"));
            this.topPanel.add(Box.createHorizontalGlue());
            this.topPanel.add(this.getHostTextField());
        }
        return this.topPanel;
    }

    public String getQuadHTTPAddress() {
        String ip = this.getHostTextField().getText();
        if (!ip.toLowerCase().startsWith("http://")) {
            ip = "http://" + ip;
        }
        return ip;
    }

    private void saveQuadHTTPAddress(String address) {
        if (address != null && !address.isEmpty()) {
            Preferences prefs = Preferences.userNodeForPackage(((Object)((Object)this)).getClass());
            prefs.put(PREF_HTTP_ADDRESS, address);
            try {
                prefs.flush();
            }
            catch (BackingStoreException e) {
                this.log.warn("Failed to save preference of 'aja-kipro-quad-address'");
            }
        }
    }
}

