/*
 * Decompiled with CFR 0.152.
 */
package vars.avplayer.kipro;

import java.awt.Frame;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.bushe.swing.event.EventBus;
import org.mbari.util.Tuple2;
import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.decorators.SchedulerVideoIO;
import org.mbari.vcr4j.decorators.VCRSyncDecorator;
import org.mbari.vcr4j.kipro.QuadError;
import org.mbari.vcr4j.kipro.QuadState;
import org.mbari.vcr4j.kipro.QuadVideoIO;
import vars.ToolBelt;
import vars.annotation.VideoArchive;
import vars.avplayer.ImageCaptureService;
import vars.avplayer.VideoController;
import vars.avplayer.VideoPlayer;
import vars.avplayer.VideoPlayerDialogUI;
import vars.avplayer.kipro.QuadVideoPlayerDialogUI;
import vars.avplayer.noop.NoopImageCaptureService;
import vars.avplayer.rx.SetVideoArchiveMsg;
import vars.avplayer.rx.SetVideoControllerMsg;
import vars.shared.rx.RXEventBus;
import vars.shared.ui.GlobalStateLookup;

public class QuadVideoPlayer
implements VideoPlayer<QuadState, QuadError> {
    private final ImageCaptureService imageCaptureService = new NoopImageCaptureService();
    private QuadVideoPlayerDialogUI dialogUI;

    public boolean canPlay(String mimeType) {
        return false;
    }

    public CompletableFuture<Tuple2<VideoArchive, VideoController<QuadState, QuadError>>> openVideoArchive(ToolBelt toolBelt, Object ... args) {
        return null;
    }

    public VideoPlayerDialogUI<QuadState, QuadError> getConnectionDialog(ToolBelt toolBelt, RXEventBus eventBus) {
        if (this.dialogUI == null) {
            Frame window = GlobalStateLookup.getSelectedFrame();
            this.dialogUI = new QuadVideoPlayerDialogUI(window, toolBelt);
            this.dialogUI.onOkay(() -> {
                this.dialogUI.setVisible(false);
                VideoArchive videoArchive = this.dialogUI.openVideoArchive();
                String httpAddress = this.dialogUI.getQuadHTTPAddress();
                VideoController videoController = new VideoController(this.imageCaptureService, this.newVideoIO(httpAddress));
                eventBus.send((Object)new SetVideoArchiveMsg(videoArchive));
                eventBus.send((Object)new SetVideoControllerMsg(videoController));
            });
        }
        return this.dialogUI;
    }

    public String getName() {
        return "AJA KiPro Quad";
    }

    private VideoIO<QuadState, QuadError> newVideoIO(String httpAddress) {
        SchedulerVideoIO io = null;
        try {
            QuadVideoIO rawIO = QuadVideoIO.open((String)httpAddress);
            new VCRSyncDecorator((VideoIO)rawIO);
            io = new SchedulerVideoIO((VideoIO)rawIO, (Executor)Executors.newSingleThreadExecutor());
        }
        catch (Exception e) {
            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
        }
        return io;
    }
}

