/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.kipro.json;

import com.google.gson.Gson;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mbari.vcr4j.kipro.json.Constants;
import org.mbari.vcr4j.time.Timecode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigEvent {
    private static final Gson gson = Constants.GSON;
    private static final Logger log = LoggerFactory.getLogger(ConfigEvent.class);
    private int intValue;
    private int lastConfigUpdate;
    private String paramId;
    private int paramType;
    private String strValue;

    public ConfigEvent(int intValue, int lastConfigUpdate, String paramId, int paramType, String strValue) {
        this.intValue = intValue;
        this.lastConfigUpdate = lastConfigUpdate;
        this.paramId = paramId;
        this.paramType = paramType;
        this.strValue = strValue;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public int getLastConfigUpdate() {
        return this.lastConfigUpdate;
    }

    public String getParamId() {
        return this.paramId;
    }

    public int getParamType() {
        return this.paramType;
    }

    public String getStrValue() {
        return this.strValue;
    }

    public static ConfigEvent[] fromJSON(String json) {
        return (ConfigEvent[])gson.fromJson(json, ConfigEvent[].class);
    }

    public String toJSON() {
        return gson.toJson((Object)this);
    }

    public static String buildRequest(String httpAddress, int connectionID) {
        return httpAddress + "config?action=wait_for_config_events&connectionid=" + connectionID;
    }

    public static Optional<Timecode> toTimecode(ConfigEvent[] events) {
        List timecodes = Arrays.stream(events).filter(e -> e.paramId.equalsIgnoreCase(Constants.EParams.DISPLAY_TIMECODE)).map(e -> new Timecode(e.getStrValue())).collect(Collectors.toList());
        if (timecodes.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(timecodes.get(0));
    }
}

