/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.kipro.examples;

import java.util.Optional;
import org.mbari.vcr4j.kipro.QuadVideoIO;
import org.mbari.vcr4j.kipro.json.ConfigEvent;
import org.mbari.vcr4j.kipro.json.ConnectionID;
import org.mbari.vcr4j.time.Timecode;

public class SimpleDemo {
    public static void main(String[] args) throws Exception {
        String httpAddress = args[0];
        String connectRequest = ConnectionID.buildRequest(httpAddress);
        System.out.println("REQUEST: " + connectRequest);
        String cid = QuadVideoIO.sendRequest(connectRequest);
        System.out.println("RESPONSE: " + cid);
        int connectionID = ConnectionID.fromJSON(cid).getConnectionid();
        System.out.println("ConnectionID = " + connectionID);
        for (int i = 0; i < 10; ++i) {
            String request = ConfigEvent.buildRequest(httpAddress, connectionID);
            System.out.println(request);
            String r = QuadVideoIO.sendRequest(request);
            System.out.println("RESPONSE: " + r);
            ConfigEvent[] ces = ConfigEvent.fromJSON(r);
            Optional<Timecode> timecode = ConfigEvent.toTimecode(ces);
            if (!timecode.isPresent()) {
                System.out.println("No timecode was found");
            } else {
                System.out.println("Timecode: " + timecode.get());
            }
            Thread.sleep(1000L);
        }
    }
}

