/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.kipro.decorators;

import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.decorators.LoggingDecorator;
import org.mbari.vcr4j.kipro.QuadError;
import org.mbari.vcr4j.kipro.QuadState;
import org.mbari.vcr4j.kipro.decorators.QuadErrorAsString;
import rx.Subscriber;

public class QuadLoggingDecorator
extends LoggingDecorator<QuadState, QuadError> {
    protected final Subscriber<QuadError> quadErrorSubscriber = new Subscriber<QuadError>(){

        public void onCompleted() {
            QuadLoggingDecorator.this.log.debug("Error observable is closed");
        }

        public void onError(Throwable throwable) {
            QuadLoggingDecorator.this.log.debug("An error occurred in the error observable", throwable);
        }

        public void onNext(QuadError error) {
            if (QuadLoggingDecorator.this.log.isDebugEnabled()) {
                QuadLoggingDecorator.this.log.debug("Received: " + new QuadErrorAsString(error).toString());
            }
        }
    };

    public QuadLoggingDecorator(VideoIO<QuadState, QuadError> io) {
        super(io);
        this.errorSubscriber.unsubscribe();
        io.getErrorObservable().subscribe(this.quadErrorSubscriber);
    }

    public void unsubscribe() {
        super.unsubscribe();
        this.quadErrorSubscriber.unsubscribe();
    }
}

