/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.kipro.decorators;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.VideoState;
import org.mbari.vcr4j.decorators.Decorator;
import org.mbari.vcr4j.kipro.QuadError;
import org.mbari.vcr4j.kipro.commands.QuadVideoCommands;
import rx.Observable;
import rx.Subscriber;

public class ConnectionPollingDecorator
implements Decorator {
    private AtomicBoolean isConnected = new AtomicBoolean(false);
    protected final Subscriber<QuadError> errorSubscriber = new Subscriber<QuadError>(){

        public void onCompleted() {
        }

        public void onError(Throwable throwable) {
        }

        public void onNext(QuadError quadError) {
            ConnectionPollingDecorator.this.isConnected.set(!quadError.hasConnectionError());
        }
    };

    public ConnectionPollingDecorator(VideoIO<? extends VideoState, QuadError> io) {
        io.getErrorObservable().subscribe(this.errorSubscriber);
        Observable.interval((long)5L, (TimeUnit)TimeUnit.SECONDS).subscribe(x -> {
            if (!this.isConnected.get()) {
                io.getCommandSubject().onNext((Object)QuadVideoCommands.CONNECT);
            }
        });
        Observable.interval((long)50L, (TimeUnit)TimeUnit.MILLISECONDS).subscribe(x -> {
            if (this.isConnected.get()) {
                io.getCommandSubject().onNext((Object)QuadVideoCommands.CONFIG_EVENT);
            }
        });
    }

    public void unsubscribe() {
        this.errorSubscriber.unsubscribe();
    }
}

