/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.kipro;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.VideoIndex;
import org.mbari.vcr4j.commands.InjectVideoIndexCmd;
import org.mbari.vcr4j.commands.SimpleVideoCommand;
import org.mbari.vcr4j.commands.VideoCommands;
import org.mbari.vcr4j.kipro.KiProException;
import org.mbari.vcr4j.kipro.QuadError;
import org.mbari.vcr4j.kipro.QuadState;
import org.mbari.vcr4j.kipro.commands.QuadVideoCommands;
import org.mbari.vcr4j.kipro.json.ConfigEvent;
import org.mbari.vcr4j.kipro.json.ConnectionID;
import org.mbari.vcr4j.time.Timecode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.subjects.PublishSubject;
import rx.subjects.SerializedSubject;
import rx.subjects.Subject;

public class QuadVideoIO
implements VideoIO<QuadState, QuadError> {
    private final String httpAddress;
    private final AtomicInteger connectionID = new AtomicInteger(0);
    private static final Logger log = LoggerFactory.getLogger(QuadVideoIO.class);
    private final QuadError noError = new QuadError(false, false, Optional.empty(), Optional.empty());
    private final Subject<QuadError, QuadError> errorObservable = new SerializedSubject((Subject)PublishSubject.create());
    private final Subject<QuadState, QuadState> statusObservable = new SerializedSubject((Subject)PublishSubject.create());
    private final Subject<Timecode, Timecode> timecodeObservable = new SerializedSubject((Subject)PublishSubject.create());
    private final Subject<VideoIndex, VideoIndex> indexObservable = new SerializedSubject((Subject)PublishSubject.create());
    private final Subject<ConfigEvent[], ConfigEvent[]> configEventObservable = new SerializedSubject((Subject)PublishSubject.create());
    private final Subject<VideoCommand, VideoCommand> commandSubject = new SerializedSubject((Subject)PublishSubject.create());

    public QuadVideoIO(String httpAddress) {
        this.httpAddress = httpAddress.endsWith("/") ? httpAddress : httpAddress + "/";
        this.statusObservable.map(QuadState::getConnectionID).forEach(this.connectionID::set);
        this.commandSubject.filter(vc -> vc.equals((Object)QuadVideoCommands.CONNECT)).forEach(vc -> this.connect());
        this.commandSubject.filter(vc -> vc.equals((Object)QuadVideoCommands.CONFIG_EVENT) || vc.equals(VideoCommands.REQUEST_INDEX) || vc.equals(VideoCommands.REQUEST_TIMECODE)).forEach(vc -> this.requestConfigEvent());
        this.commandSubject.filter(vc -> vc.equals(VideoCommands.REQUEST_TIMESTAMP)).forEach(vc -> {
            VideoIndex videoIndex = new VideoIndex(Optional.of(Instant.now()), Optional.empty(), Optional.empty());
            this.indexObservable.onNext((Object)videoIndex);
        });
        this.commandSubject.ofType(InjectVideoIndexCmd.class).map(SimpleVideoCommand::getValue).forEach(arg_0 -> this.indexObservable.onNext(arg_0));
        this.timecodeObservable.subscribe(tc -> {
            VideoIndex videoIndex = new VideoIndex(Optional.of(Instant.now()), Optional.empty(), Optional.of(tc));
            this.indexObservable.onNext((Object)videoIndex);
        });
        this.configEventObservable.subscribe(ces -> this.configEventsToTimecode((ConfigEvent[])ces).ifPresent(arg_0 -> this.timecodeObservable.onNext(arg_0)));
    }

    public static QuadVideoIO open(String httpAddress) {
        QuadVideoIO quadVideoIO = new QuadVideoIO(httpAddress);
        quadVideoIO.send(QuadVideoCommands.CONNECT);
        return quadVideoIO;
    }

    public void close() {
    }

    public <A extends VideoCommand> void send(A videoCommand) {
        this.commandSubject.onNext(videoCommand);
    }

    public Subject<VideoCommand, VideoCommand> getCommandSubject() {
        return this.commandSubject;
    }

    public String getConnectionID() {
        return this.httpAddress;
    }

    public Observable<QuadError> getErrorObservable() {
        return this.errorObservable;
    }

    public Observable<QuadState> getStateObservable() {
        return this.statusObservable;
    }

    public Observable<VideoIndex> getIndexObservable() {
        return this.indexObservable;
    }

    private void connect() {
        String request = ConnectionID.buildRequest(this.httpAddress);
        this.sendRequestWithErrorCheck(request).ifPresent(s -> {
            ConnectionID id = ConnectionID.fromJSON(s);
            this.statusObservable.onNext((Object)new QuadState(id.getConnectionid()));
        });
    }

    private void requestConfigEvent() {
        int cid = this.connectionID.get();
        String request = ConfigEvent.buildRequest(this.httpAddress, cid);
        Optional<String> response = this.sendRequestWithErrorCheck(request);
        ConfigEvent[] events = new ConfigEvent[]{};
        if (response.isPresent()) {
            try {
                events = ConfigEvent.fromJSON(response.get());
            }
            catch (Exception e) {
                log.debug("Failed to parse response. Response was: \n" + response);
            }
        }
        if (events.length > 0) {
            this.configEventObservable.onNext((Object)events);
        }
    }

    private Optional<Timecode> configEventsToTimecode(ConfigEvent[] configEvents) {
        if (configEvents.length > 0) {
            return ConfigEvent.toTimecode(configEvents);
        }
        return Optional.empty();
    }

    private Optional<String> sendRequestWithErrorCheck(String request) {
        Optional<String> json = Optional.empty();
        QuadError error = this.noError;
        try {
            HttpResponse response = Unirest.get((String)request).header("Accept", "application/json").asString();
            if (response.getStatus() != 200) {
                error = new QuadError(true, true, Optional.empty(), Optional.empty());
            } else {
                json = Optional.ofNullable(response.getBody());
            }
        }
        catch (UnirestException e) {
            error = new QuadError(true, true, Optional.empty(), Optional.of(e));
        }
        this.errorObservable.onNext((Object)error);
        return json;
    }

    public static String sendRequest(String request) {
        log.debug("REQUEST: {}", (Object)request);
        try {
            HttpResponse response = Unirest.get((String)request).header("Accept", "application/json").asString();
            return (String)response.getBody();
        }
        catch (UnirestException e) {
            throw new KiProException("Failed on request: " + request, e);
        }
    }
}

