/*
 * Decompiled with CFR 0.152.
 */
package vars.avplayer.noop;

import java.awt.Frame;
import java.util.concurrent.CompletableFuture;
import org.mbari.util.Tuple2;
import org.mbari.vcr4j.adapter.noop.NoopVideoError;
import org.mbari.vcr4j.adapter.noop.NoopVideoIO;
import org.mbari.vcr4j.adapter.noop.NoopVideoState;
import vars.ToolBelt;
import vars.annotation.VideoArchive;
import vars.annotation.VideoArchiveDAO;
import vars.avplayer.SimpleVideoParams;
import vars.avplayer.VideoController;
import vars.avplayer.VideoPlayer;
import vars.avplayer.VideoPlayerDialogUI;
import vars.avplayer.noop.NoopImageCaptureService;
import vars.avplayer.noop.NoopVideoPlayerDialogUI;
import vars.avplayer.rx.SetVideoArchiveMsg;
import vars.avplayer.rx.SetVideoControllerMsg;
import vars.shared.rx.RXEventBus;
import vars.shared.ui.GlobalStateLookup;

public class NoopVideoPlayer
implements VideoPlayer {
    private NoopVideoPlayerDialogUI dialogUI;
    private VideoController<NoopVideoState, NoopVideoError> videoController;

    @Override
    public boolean canPlay(String mimeType) {
        return true;
    }

    public VideoPlayerDialogUI getConnectionDialog(ToolBelt toolBelt, RXEventBus eventBus) {
        if (this.dialogUI == null) {
            Frame window = GlobalStateLookup.getSelectedFrame();
            this.dialogUI = new NoopVideoPlayerDialogUI(window, toolBelt);
            this.dialogUI.onOkay(() -> {
                this.dialogUI.setVisible(false);
                VideoArchive videoArchive = this.dialogUI.openVideoArchive();
                eventBus.send((Object)new SetVideoArchiveMsg(videoArchive));
                eventBus.send(new SetVideoControllerMsg<NoopVideoState, NoopVideoError>(this.getVideoController()));
            });
        }
        return this.dialogUI;
    }

    @Override
    public String getName() {
        return "Disconnected";
    }

    public CompletableFuture<Tuple2<VideoArchive, VideoController<NoopVideoState, NoopVideoError>>> openVideoArchive(ToolBelt toolBelt, Object ... args) {
        String platformName = (String)args[0];
        Integer sequenceNumber = (Integer)args[1];
        Integer tapeNumber = (Integer)args[2];
        Boolean isHD = (Boolean)args[3];
        SimpleVideoParams videoParams = new SimpleVideoParams(platformName, sequenceNumber, tapeNumber, isHD);
        return CompletableFuture.supplyAsync(() -> this.openVideoArchive(toolBelt, videoParams));
    }

    public Tuple2<VideoArchive, VideoController<NoopVideoState, NoopVideoError>> openVideoArchive(ToolBelt toolBelt, SimpleVideoParams videoParams) {
        VideoArchiveDAO dao = toolBelt.getAnnotationDAOFactory().newVideoArchiveDAO();
        VideoArchive videoArchive = dao.findOrCreateByParameters(videoParams.getPlatformName(), videoParams.getSequenceNumber().intValue(), videoParams.getVideoArchiveName());
        dao.close();
        return new Tuple2((Object)videoArchive, this.getVideoController());
    }

    public VideoController<NoopVideoState, NoopVideoError> getVideoController() {
        if (this.videoController == null) {
            this.videoController = new VideoController(new NoopImageCaptureService(), new NoopVideoIO());
        }
        return this.videoController;
    }
}

