/*
 * Decompiled with CFR 0.152.
 */
package vars.avplayer;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.VideoError;
import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.VideoIndex;
import org.mbari.vcr4j.VideoState;
import org.mbari.vcr4j.commands.VideoCommands;
import vars.avplayer.ImageCaptureService;

public class VideoController<S extends VideoState, E extends VideoError>
extends org.mbari.vcr4j.VideoController<S, E> {
    private final ImageCaptureService imageCaptureService;

    public VideoController(ImageCaptureService imageCaptureService, VideoIO<S, E> videoIO) {
        super(videoIO);
        this.imageCaptureService = imageCaptureService;
    }

    public ImageCaptureService getImageCaptureService() {
        return this.imageCaptureService;
    }

    public String getConnectionID() {
        return this.getVideoIO().getConnectionID();
    }

    public Future<Boolean> isStopped() {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.getVideoIO().getStateObservable().take(1).forEach(s -> future.complete(s.isStopped()));
        this.getVideoIO().send((VideoCommand)VideoCommands.REQUEST_STATUS);
        return future;
    }

    public Future<Boolean> isPlaying() {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.getVideoIO().getStateObservable().take(1).forEach(s -> future.complete(s.isPlaying()));
        this.getVideoIO().send((VideoCommand)VideoCommands.REQUEST_STATUS);
        return future;
    }

    public Future<VideoIndex> getVideoIndex() {
        CompletableFuture<VideoIndex> future = new CompletableFuture<VideoIndex>();
        this.getVideoIO().getIndexObservable().filter(vi -> vi.getTimecode().isPresent()).take(1).forEach(future::complete);
        this.getVideoIO().send((VideoCommand)VideoCommands.REQUEST_INDEX);
        return future;
    }

    public void close() {
        this.getVideoIO().close();
        this.imageCaptureService.dispose();
    }
}

