/*
 * Decompiled with CFR 0.152.
 */
package vars.avplayer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.mbari.awt.event.NonDigitConsumingKeyListener;
import org.mbari.swing.SpinningDialWaitIndicator;
import vars.CacheClearedEvent;
import vars.CacheClearedListener;
import vars.ToolBelt;

public class OpenVideoArchivePanel
extends JPanel {
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private final ItemListener rbItemListener = new SelectedRBItemListener();
    private JComboBox<String> cameraPlatformComboBox;
    private JComboBox<String> existingNamesComboBox;
    private boolean loadExistingNames = true;
    private JCheckBox hdCheckBox;
    private JLabel lblCameraPlatform;
    private JLabel lblName;
    private JLabel lblSelectName;
    private JLabel lblSequenceNumber;
    private JLabel lblTapeNumber;
    private JTextField nameTextField;
    private JRadioButton openByNameRB;
    private JRadioButton openByPlatformRB;
    private JRadioButton openExistingRB;
    private JTextField sequenceNumberTextField;
    private JTextField tapeNumberTextField;
    private JComboBox<String> cameraPlatformByNameComboBox;
    private final ToolBelt toolBelt;
    private JTextField sequenceNumberByNameTextField;

    public OpenVideoArchivePanel(ToolBelt toolBelt) {
        this.toolBelt = toolBelt;
        this.initialize();
        if (toolBelt != null) {
            toolBelt.getPersistenceCache().addCacheClearedListener(new CacheClearedListener(){

                public void afterClear(CacheClearedEvent evt) {
                    OpenVideoArchivePanel.this.loadExistingNames = true;
                }

                public void beforeClear(CacheClearedEvent evt) {
                    DefaultComboBoxModel model = (DefaultComboBoxModel)OpenVideoArchivePanel.this.getExistingNamesComboBox().getModel();
                    model.removeAllElements();
                }
            });
        }
    }

    public ButtonGroup getButtonGroup() {
        return this.buttonGroup;
    }

    public JComboBox<String> getCameraPlatformComboBox() {
        if (this.cameraPlatformComboBox == null) {
            this.cameraPlatformComboBox = new JComboBox();
            this.cameraPlatformComboBox.setModel(new DefaultComboBoxModel<String>(this.listCameraPlatforms()));
        }
        return this.cameraPlatformComboBox;
    }

    public JComboBox<String> getCameraPlatformByNameComboBox() {
        if (this.cameraPlatformByNameComboBox == null) {
            this.cameraPlatformByNameComboBox = new JComboBox();
            this.cameraPlatformByNameComboBox.setModel(new DefaultComboBoxModel<String>(this.listCameraPlatforms()));
        }
        return this.cameraPlatformByNameComboBox;
    }

    public JComboBox<String> getExistingNamesComboBox() {
        if (this.existingNamesComboBox == null) {
            this.existingNamesComboBox = new JComboBox();
        }
        return this.existingNamesComboBox;
    }

    public JCheckBox getHdCheckBox() {
        if (this.hdCheckBox == null) {
            this.hdCheckBox = new JCheckBox("Check if High Definition");
            this.hdCheckBox.setSelected(true);
        }
        return this.hdCheckBox;
    }

    private JLabel getLblCameraPlatform() {
        if (this.lblCameraPlatform == null) {
            this.lblCameraPlatform = new JLabel("Camera Platform:");
        }
        return this.lblCameraPlatform;
    }

    private JLabel getLblName() {
        if (this.lblName == null) {
            this.lblName = new JLabel("Name:");
        }
        return this.lblName;
    }

    private JLabel getLblSelectName() {
        if (this.lblSelectName == null) {
            this.lblSelectName = new JLabel("Select Name:");
        }
        return this.lblSelectName;
    }

    private JLabel getLblSequenceNumber() {
        if (this.lblSequenceNumber == null) {
            this.lblSequenceNumber = new JLabel("Sequence Number:");
        }
        return this.lblSequenceNumber;
    }

    private JLabel getLblTapeNumber() {
        if (this.lblTapeNumber == null) {
            this.lblTapeNumber = new JLabel("Tape Number:");
        }
        return this.lblTapeNumber;
    }

    public JTextField getNameTextField() {
        if (this.nameTextField == null) {
            this.nameTextField = new JTextField();
            this.nameTextField.setColumns(10);
        }
        return this.nameTextField;
    }

    public JRadioButton getOpenByNameRB() {
        if (this.openByNameRB == null) {
            this.openByNameRB = new JRadioButton("Open by Name");
            this.openByNameRB.setName(OpenType.BY_NAME.name());
            this.openByNameRB.addItemListener(this.rbItemListener);
        }
        return this.openByNameRB;
    }

    public JRadioButton getOpenByPlatformRB() {
        if (this.openByPlatformRB == null) {
            this.openByPlatformRB = new JRadioButton("Open by Platform and Sequence Number");
            this.openByPlatformRB.setName(OpenType.BY_PARAMS.name());
            this.openByPlatformRB.addItemListener(this.rbItemListener);
        }
        return this.openByPlatformRB;
    }

    public JRadioButton getOpenExistingRB() {
        if (this.openExistingRB == null) {
            this.openExistingRB = new JRadioButton("Open Existing");
            this.openExistingRB.setName(OpenType.EXISTING.name());
            this.openExistingRB.addItemListener(this.rbItemListener);
            this.openExistingRB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (OpenVideoArchivePanel.this.loadExistingNames) {
                        JComboBox<String> comboBox = OpenVideoArchivePanel.this.getExistingNamesComboBox();
                        SpinningDialWaitIndicator waitIndicator = new SpinningDialWaitIndicator(comboBox);
                        List names = OpenVideoArchivePanel.this.toolBelt.getAnnotationPersistenceService().findAllVideoArchiveNames();
                        String[] van = new String[names.size()];
                        names.toArray(van);
                        comboBox.setModel(new DefaultComboBoxModel<String>(van));
                        waitIndicator.dispose();
                        OpenVideoArchivePanel.this.loadExistingNames = false;
                    }
                }
            });
        }
        return this.openExistingRB;
    }

    public JTextField getSequenceNumberTextField() {
        if (this.sequenceNumberTextField == null) {
            this.sequenceNumberTextField = new JTextField();
            this.sequenceNumberTextField.setColumns(10);
            this.sequenceNumberTextField.addKeyListener((KeyListener)new NonDigitConsumingKeyListener());
        }
        return this.sequenceNumberTextField;
    }

    public JTextField getTapeNumberTextField() {
        if (this.tapeNumberTextField == null) {
            this.tapeNumberTextField = new JTextField();
            this.tapeNumberTextField.setColumns(10);
            this.tapeNumberTextField.addKeyListener((KeyListener)new NonDigitConsumingKeyListener());
        }
        return this.tapeNumberTextField;
    }

    protected void initialize() {
        JLabel cameraByNameLabel = new JLabel("Camera Platform:");
        JLabel sequenceNumberByNameLabel = new JLabel("Sequence Number:");
        GroupLayout groupLayout = new GroupLayout(this);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getOpenByPlatformRB()).addComponent(this.getOpenByNameRB()).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getOpenExistingRB()).addGroup(groupLayout.createSequentialGroup().addGap(29).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(cameraByNameLabel).addComponent(this.getLblName()).addComponent(sequenceNumberByNameLabel))).addGroup(groupLayout.createSequentialGroup().addGap(29).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getLblCameraPlatform()).addComponent(this.getLblSequenceNumber()).addComponent(this.getLblTapeNumber()))).addGroup(groupLayout.createSequentialGroup().addGap(29).addComponent(this.getLblSelectName()))).addGap(18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getCameraPlatformByNameComboBox(), 0, 299, Short.MAX_VALUE).addComponent(this.getNameTextField(), GroupLayout.Alignment.TRAILING, -1, 299, Short.MAX_VALUE).addComponent(this.getSequenceNumberByNameTextField(), -1, 299, Short.MAX_VALUE).addComponent(this.getExistingNamesComboBox(), 0, 299, Short.MAX_VALUE).addComponent(this.getSequenceNumberTextField(), -1, 299, Short.MAX_VALUE).addComponent(this.getTapeNumberTextField(), -1, 299, Short.MAX_VALUE).addComponent(this.getCameraPlatformComboBox(), 0, 299, Short.MAX_VALUE).addComponent(this.getHdCheckBox())))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.getOpenByPlatformRB()).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getLblCameraPlatform()).addComponent(this.getCameraPlatformComboBox(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getLblSequenceNumber()).addComponent(this.getSequenceNumberTextField(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getLblTapeNumber()).addComponent(this.getTapeNumberTextField(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getHdCheckBox()).addGap(4).addComponent(this.getOpenByNameRB()).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getNameTextField(), -2, -1, -2).addComponent(this.getLblName())).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getCameraPlatformByNameComboBox(), -2, -1, -2).addComponent(cameraByNameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(sequenceNumberByNameLabel).addComponent(this.getSequenceNumberByNameTextField(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getOpenExistingRB()).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getLblSelectName()).addComponent(this.getExistingNamesComboBox(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addContainerGap()));
        this.setLayout(groupLayout);
        this.buttonGroup.add(this.getOpenByNameRB());
        this.buttonGroup.add(this.getOpenByPlatformRB());
        this.buttonGroup.add(this.getOpenExistingRB());
        this.buttonGroup.setSelected(this.getOpenByPlatformRB().getModel(), true);
    }

    public String[] listCameraPlatforms() {
        String[] cp = new String[]{};
        try {
            List cameraPlatforms = this.toolBelt.getAnnotationPersistenceService().findAllCameraPlatforms();
            cp = new String[cameraPlatforms.size()];
            cameraPlatforms.toArray(cp);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return cp;
    }

    public JTextField getSequenceNumberByNameTextField() {
        if (this.sequenceNumberByNameTextField == null) {
            this.sequenceNumberByNameTextField = new JTextField();
            this.sequenceNumberByNameTextField.setColumns(10);
            this.sequenceNumberByNameTextField.addKeyListener((KeyListener)new NonDigitConsumingKeyListener());
        }
        return this.sequenceNumberByNameTextField;
    }

    class SelectedRBItemListener
    implements ItemListener {
        SelectedRBItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                JRadioButton radioButton = (JRadioButton)e.getItemSelectable();
                OpenType openType = OpenType.valueOf(radioButton.getName());
                boolean cameraPlatformCB = false;
                boolean sequenceNumberTF = false;
                boolean hdChckB = false;
                boolean nameTF = false;
                boolean existingNamesCB = false;
                boolean tapeNumberTF = false;
                boolean cameraPlatformByNameCB = false;
                boolean sequenceNumberByNameTF = false;
                switch (openType) {
                    case BY_NAME: {
                        nameTF = true;
                        cameraPlatformByNameCB = true;
                        sequenceNumberByNameTF = true;
                        break;
                    }
                    case BY_PARAMS: {
                        cameraPlatformCB = true;
                        sequenceNumberTF = true;
                        tapeNumberTF = true;
                        hdChckB = true;
                        break;
                    }
                    case EXISTING: {
                        existingNamesCB = true;
                        break;
                    }
                }
                OpenVideoArchivePanel.this.getCameraPlatformComboBox().setEnabled(cameraPlatformCB);
                OpenVideoArchivePanel.this.getSequenceNumberTextField().setEnabled(sequenceNumberTF);
                OpenVideoArchivePanel.this.getHdCheckBox().setEnabled(hdChckB);
                OpenVideoArchivePanel.this.getNameTextField().setEnabled(nameTF);
                OpenVideoArchivePanel.this.getCameraPlatformByNameComboBox().setEnabled(cameraPlatformByNameCB);
                OpenVideoArchivePanel.this.getSequenceNumberByNameTextField().setEnabled(sequenceNumberByNameTF);
                OpenVideoArchivePanel.this.getExistingNamesComboBox().setEnabled(existingNamesCB);
                OpenVideoArchivePanel.this.getTapeNumberTextField().setEnabled(tapeNumberTF);
            }
        }
    }

    private static enum OpenType {
        BY_PARAMS,
        BY_NAME,
        EXISTING;

    }
}

