/*
 * Decompiled with CFR 0.152.
 */
package vars.avplayer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import org.mbari.vcr4j.VideoError;
import org.mbari.vcr4j.VideoState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.ToolBelt;
import vars.annotation.VideoArchive;
import vars.annotation.VideoArchiveDAO;
import vars.avplayer.OpenVideoArchivePanel;
import vars.avplayer.VideoPlayerDialogUI;
import vars.shared.ui.dialogs.StandardDialog;

public abstract class OpenVideoArchiveDialog<S extends VideoState, E extends VideoError>
extends StandardDialog
implements VideoPlayerDialogUI<S, E> {
    private final ToolBelt toolBelt;
    private Runnable okRunnable = () -> {};
    private Runnable cancelRunnable = () -> this.setVisible(false);
    private OpenVideoArchivePanel centerPanel;
    public static final String PREF_PLATFORM_NAME = "platform-name";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public OpenVideoArchiveDialog(Window parent, ToolBelt toolBelt) {
        super(parent);
        this.toolBelt = toolBelt;
        this.initialize();
        this.getRootPane().setDefaultButton(this.getOkayButton());
    }

    private void initialize() {
        this.setPreferredSize(new Dimension(475, 475));
        this.getOkayButton().addActionListener(e -> this.okRunnable.run());
        this.getCancelButton().addActionListener(e -> this.cancelRunnable.run());
        this.getContentPane().add((Component)this.getCenterPanel(), "Center");
    }

    protected ToolBelt getToolBelt() {
        return this.toolBelt;
    }

    protected OpenVideoArchivePanel getCenterPanel() {
        if (this.centerPanel == null) {
            this.centerPanel = new OpenVideoArchivePanel(this.toolBelt);
            KeyAdapter keyListener = new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        OpenVideoArchiveDialog.this.getOkayButton().doClick();
                    }
                    super.keyReleased(e);
                }
            };
            this.centerPanel.getHdCheckBox().addKeyListener(keyListener);
            this.centerPanel.getTapeNumberTextField().addKeyListener(keyListener);
            this.centerPanel.getTapeNumberTextField().addKeyListener(keyListener);
            this.centerPanel.getSequenceNumberByNameTextField().addKeyListener(keyListener);
        }
        return this.centerPanel;
    }

    @Override
    public void onCancel(Runnable fn) {
        this.cancelRunnable = fn;
    }

    @Override
    public void onOkay(Runnable fn) {
        this.okRunnable = fn;
    }

    protected OpenType getOpenType() {
        Enumeration<AbstractButton> e = this.getCenterPanel().getButtonGroup().getElements();
        OpenType openType = null;
        while (e.hasMoreElements()) {
            AbstractButton b = e.nextElement();
            if (!b.isSelected()) continue;
            openType = OpenType.valueOf(b.getName());
            break;
        }
        return openType == null ? OpenType.BY_PARAMS : openType;
    }

    public VideoArchive openVideoArchive() {
        VideoArchive videoArchive = null;
        switch (this.getOpenType()) {
            case BY_NAME: {
                videoArchive = this.openVideoArchiveByName();
                break;
            }
            case BY_PARAMS: {
                videoArchive = this.openVideoArchiveByParams();
                break;
            }
            case EXISTING: {
                videoArchive = this.openExistingVideoArchive();
                break;
            }
        }
        if (videoArchive != null) {
            this.savePlatformPreferences(videoArchive.getVideoArchiveSet().getPlatformName());
        }
        return videoArchive;
    }

    private void savePlatformPreferences(String platform) {
        if (platform != null && !platform.isEmpty()) {
            Preferences prefs = Preferences.userNodeForPackage(this.getClass());
            prefs.put(PREF_PLATFORM_NAME, platform);
            try {
                prefs.flush();
            }
            catch (BackingStoreException e) {
                this.log.warn("Failed to save preference of 'platform-name'");
            }
        }
    }

    protected VideoArchive openVideoArchiveByName() {
        OpenVideoArchivePanel cp = this.getCenterPanel();
        VideoArchiveDAO dao = this.toolBelt.getAnnotationDAOFactory().newVideoArchiveDAO();
        dao.startTransaction();
        String videoArchiveName = cp.getNameTextField().getText();
        int sequenceNumber = Integer.parseInt(cp.getSequenceNumberByNameTextField().getText());
        String platform = (String)cp.getCameraPlatformComboBox().getSelectedItem();
        VideoArchive videoArchive = dao.findOrCreateByParameters(platform, sequenceNumber, videoArchiveName);
        dao.endTransaction();
        return videoArchive;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            Preferences prefs = Preferences.userNodeForPackage(this.getClass());
            String platformName = prefs.get(PREF_PLATFORM_NAME, "");
            if (platformName.isEmpty()) {
                try {
                    platformName = this.getCenterPanel().listCameraPlatforms()[0];
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!platformName.isEmpty()) {
                this.getCenterPanel().getCameraPlatformByNameComboBox().setSelectedItem(platformName);
                this.getCenterPanel().getCameraPlatformComboBox().setSelectedItem(platformName);
            }
        }
        super.setVisible(b);
    }

    protected abstract VideoArchive openVideoArchiveByParams();

    protected VideoArchive openExistingVideoArchive() {
        OpenVideoArchivePanel cp = this.getCenterPanel();
        VideoArchiveDAO dao = this.toolBelt.getAnnotationDAOFactory().newVideoArchiveDAO();
        dao.startTransaction();
        String name = (String)cp.getExistingNamesComboBox().getSelectedItem();
        VideoArchive videoArchive = dao.findByName(name);
        dao.endTransaction();
        return videoArchive;
    }

    private static enum OpenType {
        BY_PARAMS,
        BY_NAME,
        EXISTING;

    }
}

