/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.videoset;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Comparator;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.mbari.swing.SearchableComboBoxModel;
import org.mbari.text.ObjectToStringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.ILink;
import vars.LinkBean;
import vars.LinkComparator;
import vars.LinkUtilities;
import vars.annotation.CameraDirections;
import vars.annotation.VideoArchiveSet;
import vars.annotation.ui.CameraDirectionComboBox;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.actions.ClearDatabaseCacheAction;
import vars.annotation.ui.eventbus.ObservationsAddedEvent;
import vars.annotation.ui.eventbus.ObservationsChangedEvent;
import vars.annotation.ui.eventbus.ObservationsRemovedEvent;
import vars.annotation.ui.eventbus.ObservationsSelectedEvent;
import vars.annotation.ui.eventbus.UIEventSubscriber;
import vars.annotation.ui.eventbus.VideoArchiveChangedEvent;
import vars.annotation.ui.eventbus.VideoArchiveSelectedEvent;
import vars.annotation.ui.eventbus.VideoFramesChangedEvent;
import vars.annotation.ui.table.JXObservationTable;
import vars.annotation.ui.videoset.VideoArchiveSetEditorPanelController;
import vars.shared.ui.ConceptNameComboBox;
import vars.shared.ui.LinkListCellRenderer;

public class VideoArchiveSetEditorPanel
extends JPanel
implements UIEventSubscriber {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private JPanel actionPanel;
    private JComboBox associationComboBox;
    private JButton btnAddAssociation;
    private JButton btnDelete;
    private JButton btnMoveFrames;
    private JButton btnRefresh;
    private JButton btnRemoveAssociations;
    private JButton btnRenameConcepts;
    private JButton btnReplaceAssociations;
    private JButton btnSearch;
    private JComboBox cameraDirectionCB;
    private JCheckBox chckbxAssociation;
    private JCheckBox chckbxConcept;
    private ConceptNameComboBox conceptComboBox;
    private final VideoArchiveSetEditorPanelController controller;
    private JPanel controlsPanel;
    private JPanel innerPanel;
    private JScrollPane scrollPane;
    private JPanel searchPanel;
    private JXObservationTable table;
    private JToolBar toolBar;
    private volatile VideoArchiveSet videoArchiveSet;

    public VideoArchiveSetEditorPanel(ToolBelt toolBelt) {
        this.initialize();
        this.controller = new VideoArchiveSetEditorPanelController(this, toolBelt);
        AnnotationProcessor.process((Object)this);
    }

    private JPanel getActionPanel() {
        if (this.actionPanel == null) {
            this.actionPanel = new JPanel();
            this.actionPanel.setLayout(new FlowLayout(1, 5, 5));
        }
        return this.actionPanel;
    }

    public JComboBox getAssociationComboBox() {
        if (this.associationComboBox == null) {
            this.associationComboBox = new JComboBox();
            this.associationComboBox.setRenderer(new LinkListCellRenderer());
            SearchableComboBoxModel model = new SearchableComboBoxModel((Comparator)new LinkComparator(), (ObjectToStringConverter)new ObjectToStringConverter<ILink>(){

                public String convert(ILink object) {
                    return LinkUtilities.formatAsString((ILink)object);
                }
            });
            this.associationComboBox.setModel(model);
            LinkBean link = new LinkBean("nil", "nil", "nil");
            model.addElement((Object)link);
            this.associationComboBox.setSelectedItem(link);
        }
        return this.associationComboBox;
    }

    private JButton getBtnAddAssociation() {
        if (this.btnAddAssociation == null) {
            this.btnAddAssociation = new JButton("");
            this.btnAddAssociation.setToolTipText("Add Association");
            this.btnAddAssociation.setIcon(new ImageIcon(this.getClass().getResource("/images/vars/annotation/branch_add.png")));
            this.btnAddAssociation.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VideoArchiveSetEditorPanel.this.controller.addAssociation();
                }
            });
        }
        return this.btnAddAssociation;
    }

    private JButton getBtnDelete() {
        if (this.btnDelete == null) {
            this.btnDelete = new JButton("");
            this.btnDelete.setToolTipText("Delete Observations");
            this.btnDelete.setIcon(new ImageIcon(this.getClass().getResource("/images/vars/annotation/row_delete.png")));
            this.btnDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VideoArchiveSetEditorPanel.this.controller.deleteObservations();
                }
            });
        }
        return this.btnDelete;
    }

    private JButton getBtnMoveFrames() {
        if (this.btnMoveFrames == null) {
            this.btnMoveFrames = new JButton("");
            this.btnMoveFrames.setToolTipText("Move Frames");
            this.btnMoveFrames.setIcon(new ImageIcon(this.getClass().getResource("/images/vars/annotation/row_replace.png")));
            this.btnMoveFrames.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VideoArchiveSetEditorPanel.this.controller.moveObservations();
                    ClearDatabaseCacheAction action = new ClearDatabaseCacheAction(VideoArchiveSetEditorPanel.this.controller.getToolBelt());
                    action.doAction();
                }
            });
        }
        return this.btnMoveFrames;
    }

    private JButton getBtnRefresh() {
        if (this.btnRefresh == null) {
            this.btnRefresh = new JButton("");
            this.btnRefresh.setToolTipText("Refresh");
            this.btnRefresh.setIcon(new ImageIcon(this.getClass().getResource("/images/vars/annotation/refresh.png")));
            this.btnRefresh.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VideoArchiveSetEditorPanel.this.controller.refresh();
                }
            });
        }
        return this.btnRefresh;
    }

    private JButton getBtnRemoveAssociations() {
        if (this.btnRemoveAssociations == null) {
            this.btnRemoveAssociations = new JButton("");
            this.btnRemoveAssociations.setToolTipText("Remove Associations");
            this.btnRemoveAssociations.setIcon(new ImageIcon(this.getClass().getResource("/images/vars/annotation/branch_delete.png")));
            this.btnRemoveAssociations.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VideoArchiveSetEditorPanel.this.controller.removeAssociations();
                }
            });
        }
        return this.btnRemoveAssociations;
    }

    private JButton getBtnRenameConcepts() {
        if (this.btnRenameConcepts == null) {
            this.btnRenameConcepts = new JButton("");
            this.btnRenameConcepts.setToolTipText("Rename Observations");
            this.btnRenameConcepts.setIcon(new ImageIcon(this.getClass().getResource("/images/vars/annotation/row_edit.png")));
            this.btnRenameConcepts.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VideoArchiveSetEditorPanel.this.controller.renameObservations();
                }
            });
        }
        return this.btnRenameConcepts;
    }

    private JButton getBtnReplaceAssociations() {
        if (this.btnReplaceAssociations == null) {
            this.btnReplaceAssociations = new JButton("");
            this.btnReplaceAssociations.setToolTipText("Replace Associations");
            this.btnReplaceAssociations.setIcon(new ImageIcon(this.getClass().getResource("/images/vars/annotation/branch_edit.png")));
            this.btnReplaceAssociations.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VideoArchiveSetEditorPanel.this.controller.renameAssociations();
                }
            });
        }
        return this.btnReplaceAssociations;
    }

    private JButton getBtnSearch() {
        if (this.btnSearch == null) {
            this.btnSearch = new JButton("Search");
            this.btnSearch.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VideoArchiveSetEditorPanel.this.controller.search();
                }
            });
        }
        return this.btnSearch;
    }

    protected JCheckBox getChckbxAssociation() {
        if (this.chckbxAssociation == null) {
            this.chckbxAssociation = new JCheckBox("Association");
        }
        return this.chckbxAssociation;
    }

    protected JCheckBox getChckbxConcept() {
        if (this.chckbxConcept == null) {
            this.chckbxConcept = new JCheckBox("Concept");
        }
        return this.chckbxConcept;
    }

    protected ConceptNameComboBox getConceptComboBox() {
        if (this.conceptComboBox == null) {
            this.conceptComboBox = new ConceptNameComboBox();
        }
        return this.conceptComboBox;
    }

    private JPanel getControlsPanel() {
        if (this.controlsPanel == null) {
            this.controlsPanel = new JPanel();
            this.controlsPanel.setLayout(new BoxLayout(this.controlsPanel, 0));
            this.controlsPanel.add(this.getSearchPanel());
            this.controlsPanel.add(this.getActionPanel());
        }
        return this.controlsPanel;
    }

    private JPanel getInnerPanel() {
        if (this.innerPanel == null) {
            this.innerPanel = new JPanel();
            this.innerPanel.setLayout(new BorderLayout(0, 0));
            this.innerPanel.add((Component)this.getScrollPane(), "Center");
            this.innerPanel.add((Component)this.getControlsPanel(), "North");
        }
        return this.innerPanel;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setViewportView((Component)((Object)this.getTable()));
        }
        return this.scrollPane;
    }

    private JPanel getSearchPanel() {
        if (this.searchPanel == null) {
            this.searchPanel = new JPanel();
            GroupLayout gl_searchPanel = new GroupLayout(this.searchPanel);
            gl_searchPanel.setHorizontalGroup(gl_searchPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_searchPanel.createSequentialGroup().addContainerGap().addGroup(gl_searchPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_searchPanel.createSequentialGroup().addGroup(gl_searchPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getChckbxAssociation()).addComponent(this.getChckbxConcept())).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_searchPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.getConceptComboBox(), 0, 309, Short.MAX_VALUE).addComponent(this.getAssociationComboBox(), 0, 309, Short.MAX_VALUE))).addComponent(this.getBtnSearch(), GroupLayout.Alignment.TRAILING)).addContainerGap()));
            gl_searchPanel.setVerticalGroup(gl_searchPanel.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(gl_searchPanel.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(gl_searchPanel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getChckbxConcept()).addComponent((Component)this.getConceptComboBox(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_searchPanel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getChckbxAssociation()).addComponent(this.getAssociationComboBox(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getBtnSearch())));
            this.searchPanel.setLayout(gl_searchPanel);
        }
        return this.searchPanel;
    }

    protected JXObservationTable getTable() {
        if (this.table == null) {
            this.table = new JXObservationTable(true);
            this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        VideoArchiveSetEditorPanel.this.getCameraDirectionCB().setSelectedItem(null);
                    }
                }
            });
        }
        return this.table;
    }

    private JToolBar getToolBar() {
        if (this.toolBar == null) {
            this.toolBar = new JToolBar();
            this.toolBar.add(this.getBtnRefresh());
            this.toolBar.add(this.getBtnMoveFrames());
            this.toolBar.add(this.getBtnRenameConcepts());
            this.toolBar.add(this.getBtnDelete());
            this.toolBar.add(this.getBtnAddAssociation());
            this.toolBar.add(this.getBtnReplaceAssociations());
            this.toolBar.add(this.getBtnRemoveAssociations());
            this.toolBar.add(this.getCameraDirectionCB());
        }
        return this.toolBar;
    }

    private JComboBox getCameraDirectionCB() {
        if (this.cameraDirectionCB == null) {
            this.cameraDirectionCB = new CameraDirectionComboBox();
            this.cameraDirectionCB.setToolTipText("Change the camera direction of the selected video-frames");
            this.cameraDirectionCB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        VideoArchiveSetEditorPanel.this.controller.changeCameraDirectionsTo((CameraDirections)VideoArchiveSetEditorPanel.this.cameraDirectionCB.getSelectedItem());
                    }
                }
            });
        }
        return this.cameraDirectionCB;
    }

    public synchronized VideoArchiveSet getVideoArchiveSet() {
        return this.videoArchiveSet;
    }

    private void initialize() {
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.getInnerPanel(), "Center");
        this.add((Component)this.getToolBar(), "North");
    }

    public synchronized void setVideoArchiveSet(VideoArchiveSet videoArchiveSet) {
        this.videoArchiveSet = videoArchiveSet;
        this.refresh();
    }

    @Override
    @EventSubscriber(eventClass=ObservationsAddedEvent.class)
    public void respondTo(ObservationsAddedEvent event) {
    }

    @Override
    @EventSubscriber(eventClass=ObservationsChangedEvent.class)
    public void respondTo(ObservationsChangedEvent event) {
    }

    @Override
    @EventSubscriber(eventClass=ObservationsRemovedEvent.class)
    public void respondTo(ObservationsRemovedEvent event) {
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VideoArchiveSetEditorPanel.this.controller.refresh();
            }
        });
    }

    @Override
    public void respondTo(ObservationsSelectedEvent event) {
    }

    @Override
    @EventSubscriber(eventClass=VideoArchiveChangedEvent.class)
    public void respondTo(VideoArchiveChangedEvent event) {
        this.refresh();
    }

    @Override
    @EventSubscriber(eventClass=VideoArchiveSelectedEvent.class)
    public void respondTo(VideoArchiveSelectedEvent event) {
        this.refresh();
    }

    @Override
    @EventSubscriber(eventClass=VideoFramesChangedEvent.class)
    public void respondTo(VideoFramesChangedEvent event) {
    }
}

