/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.videoset;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JToggleButton;
import vars.annotation.VideoArchive;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.videoset.VideoArchiveSetEditorPanel;

public class VideoArchiveSetEditorButton
extends JToggleButton {
    private JFrame frame;
    private VideoArchiveSetEditorPanel panel;
    private final ToolBelt toolBelt;

    public VideoArchiveSetEditorButton(ToolBelt toolBelt) {
        this.toolBelt = toolBelt;
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    VideoArchiveSetEditorButton.this.getFrame().setVisible(true);
                } else if (VideoArchiveSetEditorButton.this.frame != null) {
                    VideoArchiveSetEditorButton.this.getFrame().setVisible(false);
                    VideoArchiveSetEditorButton.this.getFrame().dispose();
                    VideoArchiveSetEditorButton.this.frame = null;
                    System.gc();
                }
            }
        });
        this.setEnabled(false);
        this.setIcon(new ImageIcon(this.getClass().getResource("/images/vars/annotation/24px/table_edit.png")));
        this.setText("");
        this.setToolTipText("Edit VideoArchiveSet");
        StateLookup.videoArchiveProperty().addListener((obs, oldVal, newVal) -> this.setEnabled(newVal != null));
    }

    private VideoArchiveSetEditorPanel getPanel() {
        if (this.panel == null) {
            this.panel = new VideoArchiveSetEditorPanel(this.toolBelt);
        }
        return this.panel;
    }

    private JFrame getFrame() {
        if (this.frame == null) {
            this.frame = new JFrame("VARS - VideoArchiveSet Editor");
            this.frame.setLayout(new BorderLayout());
            this.frame.add((Component)this.getPanel(), "Center");
            this.frame.setDefaultCloseOperation(2);
            this.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    VideoArchiveSetEditorButton.this.setSelected(false);
                    VideoArchiveSetEditorButton.this.frame = null;
                    System.gc();
                }
            });
            this.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    VideoArchiveSetEditorButton.this.refresh();
                }

                @Override
                public void windowDeiconified(WindowEvent e) {
                    VideoArchiveSetEditorButton.this.refresh();
                }

                @Override
                public void windowActivated(WindowEvent e) {
                    VideoArchiveSetEditorButton.this.refresh();
                }
            });
            this.frame.pack();
        }
        return this.frame;
    }

    private void refresh() {
        VideoArchive videoArchive = StateLookup.getVideoArchive();
        if (videoArchive != null) {
            this.panel.setVideoArchiveSet(videoArchive.getVideoArchiveSet());
        } else {
            this.panel.setVideoArchiveSet(null);
        }
    }
}

