/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.video.imagecapture;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.mbari.vcr4j.VideoIndex;
import org.mbari.vcr4j.time.Timecode;

public class SnapTime {
    private static final NumberFormat format4i = new DecimalFormat("0000");
    private static final NumberFormat format3i = new DecimalFormat("000");
    private static final DateFormat dateFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy");
    private static final DateFormat timezoneFormat = new SimpleDateFormat("ZZ");
    private final Calendar gmtCalendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    private final Instant observationTimestamp;
    private final Date observationDate;
    private final VideoIndex videoIndex;

    public SnapTime(Instant observationTimestamp, VideoIndex videoIndex) {
        this.observationTimestamp = observationTimestamp;
        this.videoIndex = videoIndex;
        this.observationDate = Date.from(observationTimestamp);
    }

    public VideoIndex getVideoIndex() {
        return this.videoIndex;
    }

    public Instant getObservationTimestamp() {
        return this.observationTimestamp;
    }

    public Date getObservationDate() {
        return this.observationDate;
    }

    String getGmtOffset() {
        return timezoneFormat.format(this.observationDate);
    }

    public String getTimecodeString() {
        Timecode placeholder;
        if (this.videoIndex.getTimecode().isPresent()) {
            placeholder = (Timecode)this.videoIndex.getTimecode().get();
        } else if (this.videoIndex.getElapsedTime().isPresent()) {
            Duration duration = (Duration)this.videoIndex.getElapsedTime().get();
            double frames = (double)duration.toMillis() / 10.0;
            placeholder = new Timecode(frames, 100.0);
        } else {
            Instant timestamp = (Instant)this.videoIndex.getTimestamp().get();
            double centisecs = (double)timestamp.toEpochMilli() / 10.0;
            placeholder = new Timecode(centisecs, 100.0);
        }
        return placeholder.toString();
    }

    public String getFramegrabName() {
        return this.getTimecodeString().replace(":", "_");
    }

    long getTimeInSecs() {
        return this.observationDate.getTime() / 1000L;
    }

    public String getTrackingNumber() {
        return this.getYear() + this.getDayOfYear();
    }

    String getYear() {
        return format4i.format(this.gmtCalendar.get(1));
    }

    private String getDayOfYear() {
        return format3i.format(this.gmtCalendar.get(6));
    }

    String getFormattedGmtTime() {
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(this.getObservationDate());
    }

    String getFormattedLocalTime() {
        dateFormat.setTimeZone(TimeZone.getDefault());
        return dateFormat.format(this.observationDate);
    }
}

