/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.video.imagecapture;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.mbari.io.FileUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.annotation.ui.VARSProperties;
import vars.annotation.ui.video.imagecapture.SaveImageRunnable;
import vars.annotation.ui.video.imagecapture.SnapTime;

public class JPGPreviewUtilities {
    private static final Logger log = LoggerFactory.getLogger(JPGPreviewUtilities.class);
    private static final String imageCopyrightOwner = VARSProperties.getImageCopyrightOwner();

    public static void createCommentFile(File png, SnapTime snapTime) {
        block3: {
            String strAnnoText = "";
            StringBuffer s = new StringBuffer("Copyright ").append(snapTime.getYear());
            s.append(imageCopyrightOwner).append("\n");
            s.append("File      = ").append(png.getAbsolutePath()).append(" (MAIN)\n");
            s.append("EPOCHsecs = ").append(snapTime.getTimeInSecs()).append("\n");
            s.append("LocalTime = ").append(snapTime.getFormattedLocalTime()).append("\n");
            s.append("UTCTime   = ").append(snapTime.getFormattedGmtTime()).append("\n");
            s.append("YYYYJJJ   = ").append(snapTime.getTrackingNumber()).append("\n");
            s.append("AnnTC     = ").append(snapTime.getFramegrabName()).append("\n");
            s.append("SnapTC    = ").append(snapTime.getTimecodeString()).append("\n");
            s.append("Annotation= ").append("").append("\n");
            if (log.isInfoEnabled()) {
                log.info("strComment = \n" + s.toString());
            }
            File comment = FileUtilities.changeExtension((File)png, (String)".comment");
            try {
                BufferedWriter bwCmt = new BufferedWriter(new FileWriter(comment));
                bwCmt.write(s.toString());
                bwCmt.close();
            }
            catch (IOException e2) {
                if (!log.isErrorEnabled()) break block3;
                log.error("Failed to write " + comment.getAbsolutePath(), (Throwable)e2);
            }
        }
    }

    public static File createOverlayFile(File png, String[] overlayText) {
        StringBuffer text = new StringBuffer("");
        for (int i = 0; i < overlayText.length; ++i) {
            text.append(overlayText[i]).append("\n");
        }
        if (log.isInfoEnabled()) {
            log.info("strOverlay = \n" + text.toString());
        }
        File overlay = FileUtilities.changeExtension((File)png, (String)".overlay");
        try {
            BufferedWriter bwOvly = new BufferedWriter(new FileWriter(overlay));
            bwOvly.write(text.toString());
            bwOvly.close();
        }
        catch (IOException e2) {
            if (log.isErrorEnabled()) {
                log.error("Failed to create overlay file", (Throwable)e2);
            }
            overlay = null;
        }
        return overlay;
    }

    public static String[] createOverlayText(File png, SnapTime snapTime) {
        String[] s = new String[]{"Copyright " + snapTime.getYear() + " " + imageCopyrightOwner, png.getAbsolutePath() + " (MAIN)", snapTime.getFormattedGmtTime() + " GMT (local +" + snapTime.getGmtOffset().replaceFirst("-", "").replaceAll("0", "") + ")", ""};
        return s;
    }

    public static BufferedImage createJpgWithOverlay(Image image, File jpg, String[] overlayText) {
        BufferedImage bi = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D g = (Graphics2D)bi.getGraphics();
        g.drawImage(image, 0, 0, null);
        Font font = new Font("Monospaced", 0, 14);
        g.setFont(font);
        g.setColor(Color.CYAN);
        FontRenderContext frc = g.getFontRenderContext();
        boolean x = true;
        int n = 1;
        for (String s : overlayText) {
            LineMetrics lineMetrics = font.getLineMetrics(s, frc);
            float y = (lineMetrics.getHeight() + 1.0f) * (float)n + lineMetrics.getHeight();
            g.drawString(s, (float)x, y);
            ++n;
        }
        g.dispose();
        SaveImageRunnable saveRunnable = new SaveImageRunnable(bi, jpg);
        new Thread((Runnable)saveRunnable, "ImageIO-" + jpg.getName()).run();
        return bi;
    }
}

