/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.video.imagecapture;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Set;
import vars.UserAccount;
import vars.annotation.CameraDeployment;
import vars.annotation.VideoArchive;
import vars.annotation.VideoArchiveSet;
import vars.annotation.ui.StateLookup;
import vars.shared.preferences.PreferencesService;

public class ImageDirectory {
    public static final String UNKNOWN_PLATFORM = "unknown";
    public static final String UNKNOWN_SEQNUMBER = "0000";
    private static final NumberFormat format4i = new DecimalFormat("0000");
    private final PreferencesService preferencesService = new PreferencesService(StateLookup.PREFERENCES_FACTORY);

    public File getImageDirectory() throws IOException {
        File imageDir;
        UserAccount userAccount = StateLookup.getUserAccount();
        String hostname = this.preferencesService.getHostname();
        File imageTarget = this.preferencesService.findImageTarget(userAccount.getUserName(), hostname);
        VideoArchive va = StateLookup.getVideoArchive();
        VideoArchiveSet vas = va.getVideoArchiveSet();
        String platform = UNKNOWN_PLATFORM;
        if (vas != null && (platform = vas.getPlatformName()) == null) {
            platform = UNKNOWN_PLATFORM;
        }
        File rovDir = new File(new File(imageTarget, platform), "images");
        Set cpds = vas.getCameraDeployments();
        String diveNumber = UNKNOWN_SEQNUMBER;
        if (cpds.size() != 0) {
            CameraDeployment cd = (CameraDeployment)cpds.iterator().next();
            diveNumber = format4i.format(cd.getSequenceNumber());
        }
        if (!(imageDir = new File(rovDir, diveNumber)).exists()) {
            boolean ok = imageDir.mkdirs();
            if (!ok) {
                String msg = new StringBuffer().append("Unable to create the directory, ").append(imageDir.getAbsolutePath()).append(", needed to store the images").toString();
                throw new IOException(msg);
            }
        } else if (!imageDir.canWrite()) {
            String msg = new StringBuffer().append("Unable to write to the directory, ").append(imageDir.getAbsolutePath()).toString();
            throw new IOException(msg);
        }
        return imageDir;
    }
}

