/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.video.imagecapture;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.net.MalformedURLException;
import java.time.Instant;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.swing.KeyStroke;
import org.bushe.swing.event.EventBus;
import org.mbari.awt.event.ActionAdapter;
import org.mbari.awt.image.ImageUtilities;
import org.mbari.io.FileUtilities;
import org.mbari.vcr4j.VideoIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.UserAccount;
import vars.VARSException;
import vars.annotation.CameraDirections;
import vars.annotation.VideoArchive;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.commandqueue.CommandEvent;
import vars.annotation.ui.commandqueue.impl.AddObservationCmd;
import vars.annotation.ui.video.imagecapture.ImageDirectory;
import vars.annotation.ui.video.imagecapture.JPGPreviewUtilities;
import vars.annotation.ui.video.imagecapture.SaveImageRunnable;
import vars.annotation.ui.video.imagecapture.SnapTime;
import vars.avplayer.ImageCaptureService;
import vars.avplayer.VideoController;

public class ImageCaptureAction
extends ActionAdapter {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ImageDirectory imageDirectory;
    private final ToolBelt toolBelt;

    public ImageCaptureAction(ToolBelt toolBelt) {
        this.toolBelt = toolBelt;
        this.imageDirectory = new ImageDirectory();
        this.putValue("Name", "Frame Capture");
        this.putValue("ActionCommandKey", "frame capture");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    }

    public void capture() {
        VideoController videoController = StateLookup.getVideoController();
        if (videoController == null) {
            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)"You are not connected to a video. Unable to capture a frame.");
            return;
        }
        ImageCaptureService imageCaptureService = videoController.getImageCaptureService();
        if (imageCaptureService == null) {
            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)"No image capture service is available for frame capture");
            return;
        }
        VideoArchive videoArchive = StateLookup.getVideoArchive();
        if (videoArchive == null) {
            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)"No video-archive is open for annotating. Unable to capture an image.");
            return;
        }
        SnapTime snapTime = this.getSnapTime(videoController);
        File png = null;
        try {
            png = new File(this.imageDirectory.getImageDirectory(), snapTime.getFramegrabName() + ".png");
        }
        catch (Exception e) {
            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
            this.log.error("Unable to create or write to the image directory", (Throwable)e);
            return;
        }
        Optional<BufferedImage> bufferedImageOpt = this.grabImageAndSavePng(imageCaptureService, png, snapTime);
        if (!bufferedImageOpt.isPresent()) {
            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)"No image was captured");
            return;
        }
        File pngFile = png;
        Runnable runnable = () -> {
            JPGPreviewUtilities.createCommentFile(pngFile, snapTime);
            String[] overlayText = JPGPreviewUtilities.createOverlayText(pngFile, snapTime);
            JPGPreviewUtilities.createOverlayFile(pngFile, overlayText);
            File jpg = null;
            try {
                jpg = FileUtilities.changeExtension((File)pngFile, (String)".jpg");
                JPGPreviewUtilities.createJpgWithOverlay((Image)bufferedImageOpt.get(), jpg, overlayText);
            }
            catch (Exception e) {
                EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
                this.log.error("Failed to write jpg preview file to " + jpg.getAbsolutePath(), (Throwable)e);
                return;
            }
            this.updateVideoArchive(snapTime, jpg);
        };
        new Thread(runnable, "JPEG-Generation-" + snapTime.getObservationDate().getTime()).run();
    }

    public void doAction() {
        if (this.isAvailable()) {
            this.capture();
        }
    }

    private SnapTime getSnapTime(VideoController videoController) {
        Instant observationTimestamp = Instant.now();
        try {
            VideoIndex videoIndex = (VideoIndex)videoController.getVideoIndex().get(2L, TimeUnit.SECONDS);
            return new SnapTime(observationTimestamp, videoIndex);
        }
        catch (Exception e) {
            throw new VARSException("Failed to acquire SnapTime", (Throwable)e);
        }
    }

    private Optional<BufferedImage> grabImageAndSavePng(ImageCaptureService imageCaptureService, File png, SnapTime snapTime) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Attempting to save an image to " + png.getAbsolutePath());
        }
        Optional<BufferedImage> image = imageCaptureService.capture(png).map(ImageUtilities::toBufferedImage);
        image.ifPresent(i -> {
            SaveImageRunnable saveRunnable = new SaveImageRunnable((RenderedImage)i, png);
            new Thread((Runnable)saveRunnable, "ImageIO-" + png.getName()).run();
        });
        return image;
    }

    public boolean isAvailable() {
        return StateLookup.getVideoController() != null;
    }

    private void updateVideoArchive(SnapTime snapTime, File jpg) {
        VideoArchive videoArchive = StateLookup.getVideoArchive();
        if (videoArchive != null) {
            String imageReference;
            String user;
            String cameraDirection;
            block3: {
                CameraDirections cameraDirections = StateLookup.getCameraDirection();
                cameraDirection = cameraDirections.getDirection();
                UserAccount userAccount = StateLookup.getUserAccount();
                user = userAccount == null ? "default" : userAccount.getUserName();
                imageReference = null;
                try {
                    imageReference = jpg.toURI().toURL().toExternalForm();
                }
                catch (MalformedURLException e) {
                    if (!this.log.isErrorEnabled()) break block3;
                    this.log.error("Problem creating a URL.", (Throwable)e);
                }
            }
            Date recordedDate = snapTime.getVideoIndex().getTimestamp().map(Date::from).orElse(null);
            AddObservationCmd command = new AddObservationCmd("physical object", snapTime.getTimecodeString(), recordedDate, videoArchive.getName(), user, cameraDirection, null, imageReference, true);
            CommandEvent commandEvent = new CommandEvent(command);
            EventBus.publish((Object)commandEvent);
        }
    }
}

