/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.video;

import org.bushe.swing.event.EventBus;
import org.mbari.vcr4j.SimpleVideoIO;
import org.mbari.vcr4j.VideoError;
import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.VideoState;
import org.mbari.vcr4j.decorators.VCRSyncDecorator;
import org.mbari.vcr4j.rs422.VCRVideoIO;
import org.mbari.vcr4j.rs422.decorators.RS422StatusDecorator;
import org.mbari.vcr4j.rs422.decorators.UserbitsAsTimeDecorator;
import org.mbari.vcr4j.rxtx.RXTXVideoIO;
import org.mbari.vcr4j.udp.UDPVideoIO;
import vars.avfoundation.AVFImageCaptureServiceImpl;
import vars.avplayer.ImageCaptureService;
import vars.avplayer.VideoController;
import vars.avplayer.noop.NoopImageCaptureService;

public class VideoControlServiceFactory {
    public static VideoController<? extends VideoState, ? extends VideoError> newVideoController(String videoConnectionID) {
        Object videoController = null;
        try {
            if (videoConnectionID.contains(":")) {
                String[] parts = videoConnectionID.split(":");
                String host = parts[0];
                Integer port = Integer.valueOf(parts[1]);
                UDPVideoIO io = new UDPVideoIO(host, port.intValue());
                new VCRSyncDecorator((VideoIO)io);
                return new VideoController((ImageCaptureService)new NoopImageCaptureService(), (VideoIO)io);
            }
            RXTXVideoIO io = RXTXVideoIO.open((String)videoConnectionID);
            new VCRSyncDecorator((VideoIO)io);
            new RS422StatusDecorator((VCRVideoIO)io);
            UserbitsAsTimeDecorator decorator = new UserbitsAsTimeDecorator((VCRVideoIO)io);
            SimpleVideoIO io2 = new SimpleVideoIO(io.getConnectionID(), io.getCommandSubject(), io.getStateObservable(), io.getErrorObservable(), decorator.getIndexObservable());
            return new VideoController((ImageCaptureService)new AVFImageCaptureServiceImpl(), (VideoIO)io2);
        }
        catch (Exception e) {
            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
            return null;
        }
    }
}

