/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.annotation.Observation;
import vars.annotation.ui.table.ObservationTableModel;
import vars.annotation.ui.table.ValueColumn;

public class JXObservationTableModel
extends AbstractTableModel
implements ObservationTableModel {
    private final List<Object> primaryKeys = new Vector<Object>();
    private final List<Observation> observations = new Vector<Observation>();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final TableColumnModel tableColumnModel;

    public JXObservationTableModel(TableColumnModel tableColumnModel) {
        this.tableColumnModel = tableColumnModel;
    }

    @Override
    public void addObservation(Observation obs) {
        if (obs != null && obs.getVideoFrame() != null) {
            if (obs.getPrimaryKey() == null || this.primaryKeys.contains(obs.getPrimaryKey())) {
                this.log.debug("Observation does not have a primary key or is already in the TableModel");
                return;
            }
            this.primaryKeys.add(obs.getPrimaryKey());
            this.observations.add(obs);
            obs.addPropertyChangeListener("associations", (PropertyChangeListener)new AssociationListListener(obs));
            obs.addPropertyChangeListener("conceptName", (PropertyChangeListener)new ConceptNameListener(obs));
            int index = this.primaryKeys.indexOf(obs.getPrimaryKey());
            this.fireTableRowsInserted(index, index);
        } else if (this.log.isWarnEnabled()) {
            this.log.warn("Attempted to add an Observation without a parent VideoFrame to the data model. This is not allowed.");
        }
    }

    @Override
    public void clear() {
        this.observations.clear();
        this.primaryKeys.clear();
        this.redrawAll();
    }

    @Override
    public int getColumnCount() {
        return this.tableColumnModel.getColumnCount();
    }

    @Override
    public int getNumberOfObservations() {
        return this.observations.size();
    }

    @Override
    public Observation getObservationAt(int rowIndex) {
        Observation out = null;
        if (rowIndex < this.observations.size()) {
            out = this.observations.get(rowIndex);
        }
        return out;
    }

    @Override
    public int getObservationRow(Observation observation) {
        int row = -1;
        if (observation != null) {
            row = this.primaryKeys.indexOf(observation.getPrimaryKey());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Found observation, " + observation + ", at row = " + row);
        }
        return row;
    }

    @Override
    public int getRowCount() {
        return this.observations.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object out = null;
        if (rowIndex < this.observations.size()) {
            Observation obs = this.observations.get(rowIndex);
            TableColumn tc = this.tableColumnModel.getColumn(columnIndex);
            if (tc instanceof ValueColumn) {
                out = ((ValueColumn)((Object)tc)).getValue(obs);
            }
        } else if (this.log.isWarnEnabled()) {
            this.log.warn("Attempted to access an empty row in the TableModel.");
        }
        return out;
    }

    @Override
    public void redrawAll() {
        this.fireTableDataChanged();
    }

    @Override
    public void redrawRow(int row) {
        this.fireTableRowsUpdated(row, row);
    }

    @Override
    public void removeObservation(Observation obs) {
        int index = this.primaryKeys.indexOf(obs.getPrimaryKey());
        if (index >= 0) {
            PropertyChangeListener[] pcl;
            Observation observation = this.observations.get(index);
            for (PropertyChangeListener listener : pcl = observation.getPropertyChangeListeners()) {
                if (!(listener instanceof AssociationListListener) && !(listener instanceof ConceptNameListener)) continue;
                observation.removePropertyChangeListener(listener);
            }
            this.observations.remove(index);
            this.primaryKeys.remove(index);
            this.fireTableRowsDeleted(index, index);
        }
    }

    @Override
    public void updateObservation(Observation observation) {
        if (observation != null && observation.getVideoFrame() != null) {
            if (observation.getPrimaryKey() == null || !this.primaryKeys.contains(observation.getPrimaryKey())) {
                this.log.debug("Observation does not have a primary key or is not already in the TableModel");
                return;
            }
            int idx = this.primaryKeys.indexOf(observation.getPrimaryKey());
            this.observations.remove(idx);
            this.observations.add(idx, observation);
            observation.addPropertyChangeListener("associations", (PropertyChangeListener)new AssociationListListener(observation));
            observation.addPropertyChangeListener("conceptName", (PropertyChangeListener)new ConceptNameListener(observation));
            this.fireTableRowsUpdated(idx, idx);
        }
    }

    private class ConceptNameListener
    implements PropertyChangeListener {
        private final Observation observation;

        ConceptNameListener(Observation observation) {
            this.observation = observation;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            int row;
            String oldName = (String)e.getOldValue();
            String newName = (String)e.getNewValue();
            if (!(oldName != null && newName != null && oldName.equals(newName) || (row = JXObservationTableModel.this.getObservationRow(this.observation)) == -1)) {
                JXObservationTableModel.this.redrawRow(row);
            }
        }
    }

    private class AssociationListListener
    implements PropertyChangeListener {
        private final Observation observation;

        AssociationListListener(Observation observation) {
            this.observation = observation;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getNewValue() == null) {
                return;
            }
            try {
                int row = JXObservationTableModel.this.getObservationRow(this.observation);
                if (row == -1) {
                    JXObservationTableModel.this.log.warn("Attempted to redraw an Observation that can no longer be found in the UI VIew");
                } else {
                    JXObservationTableModel.this.redrawRow(row);
                }
            }
            catch (ArrayIndexOutOfBoundsException e1) {
                JXObservationTableModel.this.log.warn("Unable to find index of " + this.observation + " in table, redrawing entire view");
                JXObservationTableModel.this.redrawAll();
            }
        }
    }
}

