/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.table;

import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import vars.annotation.CameraData;
import vars.annotation.Observation;
import vars.annotation.VideoArchive;
import vars.annotation.VideoFrame;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.table.FGSCellRenderer;
import vars.annotation.ui.table.ObservationTableModel;
import vars.annotation.ui.table.TableCellRenderer4AssociationList;
import vars.annotation.ui.table.ValueColumn;

public class JXObservationTableColumnModel
extends DefaultTableColumnModelExt {
    private boolean imageView = false;

    public JXObservationTableColumnModel() {
        this.addColumn((TableColumn)((Object)new TimeCodeColumn()));
        this.addColumn((TableColumn)((Object)new ObservationColumn()));
        this.addColumn((TableColumn)((Object)new AssociationColumn()));
        this.addColumn((TableColumn)((Object)new FGSColumn()));
        this.addColumn((TableColumn)((Object)new ObserverColumn()));
        this.addColumn((TableColumn)((Object)new CameraDirectionColumn()));
        this.addColumn((TableColumn)((Object)new RecordedDateColumn()));
    }

    public JXObservationTableColumnModel(boolean showVideoArchiveName) {
        this();
        if (showVideoArchiveName) {
            this.addColumn((TableColumn)((Object)new VideoArchiveNameColumn()));
        }
    }

    public void setImageView(boolean imageView) {
        this.imageView = imageView;
        List columns = this.getColumns(true);
        for (TableColumn tableColumn : columns) {
            ValueColumn valueColumn;
            String id;
            if (!(tableColumn instanceof ValueColumn) || (id = (String)(valueColumn = (ValueColumn)((Object)tableColumn)).getIdentifier()) == null || !id.equalsIgnoreCase("Recorded Date")) continue;
            valueColumn.setVisible(imageView);
        }
    }

    public boolean isImageView() {
        return this.imageView;
    }

    public class VideoArchiveNameColumn
    extends ValueColumn {
        public static final int COLUMN_INDEX = 7;
        public static final String ID = "Tape ID";

        public VideoArchiveNameColumn() {
            super(ID, 7);
            this.setIdentifier(ID);
            this.setHeaderValue(ID);
            this.setMinWidth(20);
            this.setPreferredWidth(50);
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public Object getValue(Observation observation) {
            VideoArchive va;
            VideoFrame vf = observation.getVideoFrame();
            String value = "";
            if (vf != null && (va = vf.getVideoArchive()) != null && (value = va.getName()) == null) {
                value = "";
            }
            return value;
        }

        @Override
        public boolean isSortable() {
            return true;
        }

        @Override
        public void setValue(Observation observation, Object value) {
        }
    }

    public class TimeCodeColumn
    extends ValueColumn {
        public static final int COLUMN_INDEX = 0;
        public static final String ID = "Timecode";

        public TimeCodeColumn() {
            super(ID, 0, 90);
            this.setMinWidth(90);
            this.setMaxWidth(90);
            this.setPreferredWidth(90);
            this.setIdentifier(ID);
            this.setResizable(false);
            this.setHeaderValue(ID);
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public Object getValue(Observation observation) {
            return observation.getVideoFrame().getTimecode();
        }

        @Override
        public boolean isSortable() {
            return true;
        }

        @Override
        public void setValue(Observation observation, Object value) {
            observation.getVideoFrame().setTimecode((String)value);
        }
    }

    public class RecordedDateColumn
    extends ValueColumn {
        public static final int COLUMN_INDEX = 6;
        public static final String ID = "Recorded Date";
        public final DateFormat dateFormat;

        public RecordedDateColumn() {
            super(ID, 6, 180);
            this.dateFormat = StateLookup.getUTCDateFormat();
            this.setIdentifier(ID);
            this.setResizable(false);
            this.setHeaderValue(ID);
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public Object getValue(Observation observation) {
            Date date = observation.getVideoFrame().getRecordedDate();
            return date == null ? "    -  -     :  :   " : this.dateFormat.format(date);
        }

        @Override
        public boolean isSortable() {
            return true;
        }

        @Override
        public void setValue(Observation observation, Object value) {
        }
    }

    public class ObserverColumn
    extends ValueColumn {
        public static final int COLUMN_INDEX = 4;
        public static final String ID = "Observer";

        public ObserverColumn() {
            super(ID, 4);
            this.setIdentifier(ID);
            this.setHeaderValue(ID);
            this.setMinWidth(20);
            this.setPreferredWidth(50);
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public Object getValue(Observation observation) {
            String value = "";
            String observer = observation.getObserver();
            if (observer != null) {
                value = observer;
            }
            return value;
        }

        @Override
        public void setValue(Observation observation, Object value) {
        }
    }

    public class ObservationColumn
    extends ValueColumn {
        public static final int COLUMN_INDEX = 1;
        public static final String ID = "Observation";

        public ObservationColumn() {
            super(ID, 1, 140);
            this.setMinWidth(120);
            this.setPreferredWidth(140);
            this.setMaxWidth(200);
            this.setIdentifier(ID);
            this.setHeaderValue(ID);
        }

        @Override
        public Class getColumnClass() {
            return Observation.class;
        }

        @Override
        public Object getValue(Observation observation) {
            return observation.getConceptName();
        }

        @Override
        public boolean isSortable() {
            return true;
        }

        @Override
        public void setValue(Observation observation, Object value) {
            observation.setConceptName((String)value);
        }
    }

    class NotesColumn
    extends ValueColumn {
        public static final int COLUMN_INDEX = 8;
        public static final String ID = "Notes";

        public NotesColumn() {
            super(ID, 8);
            this.setIdentifier(ID);
            this.setHeaderValue(ID);
            this.setMinWidth(60);
            this.setPreferredWidth(130);
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public Object getValue(Observation observation) {
            return observation.getNotes();
        }

        @Override
        public boolean isSortable() {
            return false;
        }

        @Override
        public void setValue(Observation observation, Object value) {
            observation.setNotes((String)value);
        }
    }

    public class FGSColumn
    extends ValueColumn {
        public static final int COLUMN_INDEX = 3;
        public static final String ID = "FG/S";

        public FGSColumn() {
            super(ID, 3, 45);
            this.setMaxWidth(45);
            this.setMinWidth(45);
            this.setPreferredWidth(45);
            this.setIdentifier(ID);
            this.setResizable(false);
            this.setCellRenderer(new FGSCellRenderer());
            this.setHeaderValue(ID);
        }

        @Override
        public Class getColumnClass() {
            return Integer.class;
        }

        @Override
        public Object getValue(Observation observation) {
            boolean hasSample = observation.hasSample();
            boolean hasFramegrab = false;
            VideoFrame vf = observation.getVideoFrame();
            if (vf != null) {
                hasFramegrab = vf.hasImageReference();
            }
            Integer out = ObservationTableModel.NONE;
            if (hasFramegrab && hasSample) {
                out = ObservationTableModel.FRAMEGRAB_AND_SAMPLE;
            } else if (!hasFramegrab && hasSample) {
                out = ObservationTableModel.SAMPLE;
            } else if (hasFramegrab && !hasSample) {
                out = ObservationTableModel.FRAMEGRAB;
            }
            return out;
        }

        @Override
        public boolean isSortable() {
            return true;
        }
    }

    public class CameraDirectionColumn
    extends ValueColumn {
        public static final int COLUMN_INDEX = 5;
        public static final String ID = "Camera Direction";

        public CameraDirectionColumn() {
            super(ID, 5);
            this.setIdentifier(ID);
            this.setHeaderValue(ID);
            this.setMinWidth(20);
            this.setPreferredWidth(50);
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public Object getValue(Observation observation) {
            CameraData cd;
            VideoFrame vf = observation.getVideoFrame();
            String value = "";
            if (vf != null && (cd = vf.getCameraData()) != null && (value = cd.getDirection()) == null) {
                value = "";
            }
            return value;
        }

        @Override
        public boolean isSortable() {
            return true;
        }

        @Override
        public void setValue(Observation observation, Object value) {
        }
    }

    public class AssociationColumn
    extends ValueColumn {
        public static final int COLUMN_INDEX = 2;
        public static final String ID = "Descriptions";

        public AssociationColumn() {
            super(ID, 2, 120);
            this.setMinWidth(100);
            this.setPreferredWidth(140);
            this.setMaxWidth(700);
            this.setIdentifier(ID);
            this.setResizable(true);
            this.setCellRenderer((TableCellRenderer)((Object)new TableCellRenderer4AssociationList()));
            this.setHeaderValue(ID);
        }

        @Override
        public Class getColumnClass() {
            return List.class;
        }

        @Override
        public Object getValue(Observation observation) {
            return new Vector(observation.getAssociations());
        }

        @Override
        public void setValue(Observation observation, Object value) {
        }
    }
}

