/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.table;

import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SortOrder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTableHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.annotation.Observation;
import vars.annotation.ui.table.JXObservationTableColumnModel;
import vars.annotation.ui.table.JXObservationTableModel;
import vars.annotation.ui.table.ObservationTable;
import vars.annotation.ui.table.ObservationTableModel;

public class JXObservationTable
extends JXTable
implements ObservationTable {
    private final Logger log = LoggerFactory.getLogger(JXObservationTable.class);

    public JXObservationTable() {
        this(false);
    }

    public JXObservationTable(boolean showVideoArchiveName) {
        JXObservationTableColumnModel tableColumnModel = new JXObservationTableColumnModel(showVideoArchiveName);
        JXObservationTableModel model = new JXObservationTableModel((TableColumnModel)((Object)tableColumnModel));
        JXTableHeader aTableHeader = new JXTableHeader((TableColumnModel)((Object)tableColumnModel));
        aTableHeader.setReorderingAllowed(false);
        this.setModel(model);
        this.setColumnModel((TableColumnModel)((Object)tableColumnModel));
        this.setAutoCreateColumnsFromModel(true);
        this.setSortable(true);
        this.setAutoscrolls(true);
        aTableHeader.setTable((JTable)((Object)this));
        this.setTableHeader((JTableHeader)aTableHeader);
        this.setShowGrid(true, false);
        this.setGridColor(new Color(235, 235, 235));
        this.setSortOrder(0, SortOrder.ASCENDING);
    }

    @Override
    public void addObservation(Observation observation) {
        ((ObservationTableModel)((Object)this.getModel())).addObservation(observation);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Adding " + observation + " to the table model");
        }
    }

    @Override
    public void updateObservation(Observation observation) {
        ((ObservationTableModel)((Object)this.getModel())).updateObservation(observation);
    }

    public TableCellRenderer getDefaultRenderer(Class<?> columnClass) {
        TableCellRenderer renderer = super.getDefaultRenderer(columnClass);
        if (renderer == null) {
            renderer = super.getDefaultRenderer(Object.class);
        }
        return renderer;
    }

    @Override
    public Observation getObservationAt(int row) {
        ObservationTableModel model = (ObservationTableModel)((Object)this.getModel());
        return model.getObservationAt(this.convertRowIndexToModel(row));
    }

    @Override
    public int getPreferredRowHeight(int rowIndex, int margin) {
        int height = this.getRowHeight();
        for (int c = 0; c < this.getColumnCount(); ++c) {
            TableCellRenderer renderer = this.getCellRenderer(rowIndex, c);
            Component comp = this.prepareRenderer(renderer, rowIndex, c);
            int h = comp.getPreferredSize().height + 2 * margin;
            height = Math.max(height, h);
        }
        return height;
    }

    @Override
    public void redrawAll() {
        ((ObservationTableModel)((Object)this.getModel())).redrawAll();
    }

    @Override
    public void redrawRow(int row) {
        ((ObservationTableModel)((Object)this.getModel())).redrawRow(row);
    }

    @Override
    public void removeObservation(Observation observation) {
        ((ObservationTableModel)((Object)this.getModel())).removeObservation(observation);
    }

    @Override
    public void scrollToVisible(int rowIndex, int vColIndex) {
        this.scrollRowToVisible(rowIndex);
    }

    @Override
    public void setSelectedObservation(Observation obs) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Setting the observation selected in the table to " + obs);
        }
        int row = this.convertRowIndexToView(((JXObservationTableModel)this.getModel()).getObservationRow(obs));
        this.getSelectionModel().setSelectionInterval(row, row);
        this.scrollRowToVisible(row);
    }

    @Override
    public void setSelectedObservations(Collection<Observation> observations) {
        ListSelectionModel mySelectionModel = this.getSelectionModel();
        mySelectionModel.setValueIsAdjusting(true);
        mySelectionModel.clearSelection();
        JXObservationTableModel model = (JXObservationTableModel)this.getModel();
        this.getSelectionModel().clearSelection();
        for (Observation observation : observations) {
            try {
                int row = this.convertRowIndexToView(model.getObservationRow(observation));
                mySelectionModel.addSelectionInterval(row, row);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        }
        mySelectionModel.setValueIsAdjusting(false);
        int[] i = this.getSelectedRows();
        if (i != null && i.length > 0) {
            this.scrollRowToVisible(i[0]);
        }
    }

    @Override
    public JTable getJTable() {
        return this;
    }
}

