/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.roweditor;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.CacheClearedEvent;
import vars.CacheClearedListener;
import vars.DAO;
import vars.UserAccount;
import vars.annotation.Observation;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.commandqueue.CommandEvent;
import vars.annotation.ui.commandqueue.impl.ChangeObservationNameCmd;
import vars.annotation.ui.eventbus.ObservationsChangedEvent;
import vars.annotation.ui.eventbus.ObservationsSelectedEvent;
import vars.annotation.ui.roweditor.AssociationListEditorPanel;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptDAO;
import vars.shared.ui.AllConceptNamesComboBox;

public class RowEditorPanel
extends JPanel {
    private static final Set<KeyStroke> tab = ImmutableSet.of((Object)KeyStroke.getKeyStroke("TAB"));
    private static final Set<KeyStroke> shifttab = ImmutableSet.of((Object)KeyStroke.getKeyStroke("shift TAB"));
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected Action nextFocusAction = new AbstractAction("Move Focus Forwards"){

        @Override
        public void actionPerformed(ActionEvent evt) {
            ((Component)evt.getSource()).transferFocus();
        }
    };
    protected Action prevFocusAction = new AbstractAction("Move Focus Backwards"){

        @Override
        public void actionPerformed(ActionEvent evt) {
            ((Component)evt.getSource()).transferFocusBackward();
        }
    };
    private JComboBox conceptComboBox;
    private JPanel jPanel;
    private AssociationListEditorPanel listPanel;
    private Collection<String> notableConceptNames;
    private JTextArea notesArea;
    private Observation observation;
    private final ToolBelt toolBelt;

    public RowEditorPanel(ToolBelt toolBelt) {
        AnnotationProcessor.process((Object)this);
        this.toolBelt = toolBelt;
        this.initialize();
        toolBelt.getPersistenceCache().addCacheClearedListener(new CacheClearedListener(){

            public void afterClear(CacheClearedEvent evt) {
                ((AllConceptNamesComboBox)RowEditorPanel.this.getConceptComboBox()).updateConceptNames();
            }

            public void beforeClear(CacheClearedEvent evt) {
                RowEditorPanel.this.notableConceptNames = null;
            }
        });
    }

    @EventSubscriber(eventClass=ObservationsSelectedEvent.class)
    public void updateObservationSelection(ObservationsSelectedEvent selectionEvent) {
        Collection observations = (Collection)selectionEvent.get();
        Observation obs = observations.size() == 1 ? (Observation)observations.iterator().next() : null;
        this.setObservation(obs);
    }

    @EventSubscriber(eventClass=ObservationsChangedEvent.class)
    public void updateObservationReference(ObservationsChangedEvent updateEvent) {
        Observation selectedObservation = this.getObservation();
        if (selectedObservation != null) {
            DAO dao = this.toolBelt.getAnnotationDAOFactory().newDAO();
            for (Observation obs : (Collection)updateEvent.get()) {
                if (!dao.equalInDatastore((Object)selectedObservation, (Object)obs)) continue;
                this.setObservation(obs);
                break;
            }
            dao.close();
        }
    }

    private JComboBox getConceptComboBox() {
        if (this.conceptComboBox == null) {
            this.conceptComboBox = new AllConceptNamesComboBox(this.toolBelt.getQueryPersistenceService());
            this.conceptComboBox.setPreferredSize(new Dimension(250, 23));
            this.conceptComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    AssociationListEditorPanel p;
                    if (e.getStateChange() == 1) {
                        String conceptName = (String)RowEditorPanel.this.conceptComboBox.getSelectedItem();
                        RowEditorPanel.this.getNotesArea().setEditable(!RowEditorPanel.this.getNotableConceptNames().contains(conceptName));
                    }
                    if ((p = RowEditorPanel.this.getListPanel()).isEditingAssociation()) {
                        p.getAssociationEditorPanel().resetDisplay();
                        p.setEditingAssociation(false);
                    }
                }
            });
            JTextField editor = (JTextField)this.conceptComboBox.getEditor().getEditorComponent();
            editor.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent ke) {
                    char c = ke.getKeyChar();
                    if (c == '\n') {
                        String primaryName;
                        RowEditorPanel.this.log.debug("ENTER Pressed in Editor");
                        String selectedName = (String)RowEditorPanel.this.conceptComboBox.getSelectedItem();
                        RowEditorPanel.this.conceptComboBox.setPopupVisible(false);
                        RowEditorPanel.this.conceptComboBox.setEnabled(false);
                        try {
                            Concept concept = RowEditorPanel.this.toolBelt.getAnnotationPersistenceService().findConceptByName(selectedName);
                            primaryName = concept.getPrimaryConceptName().getName();
                        }
                        catch (Exception e1) {
                            RowEditorPanel.this.log.error("Failed to lookup '" + RowEditorPanel.this.conceptComboBox.getSelectedItem() + "' from database", (Throwable)e1);
                            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e1);
                            primaryName = "object";
                        }
                        if (!selectedName.equals(primaryName)) {
                            RowEditorPanel.this.conceptComboBox.setSelectedItem(primaryName);
                        }
                        if (RowEditorPanel.this.observation != null && !RowEditorPanel.this.observation.getConceptName().equals(primaryName)) {
                            UserAccount userAccount = StateLookup.getUserAccount();
                            ChangeObservationNameCmd command = new ChangeObservationNameCmd((Collection<Observation>)ImmutableList.of((Object)RowEditorPanel.this.observation), primaryName, userAccount.getUserName(), new Date());
                            CommandEvent commandEvent = new CommandEvent(command);
                            EventBus.publish((Object)commandEvent);
                        }
                        RowEditorPanel.this.conceptComboBox.setEnabled(true);
                        RowEditorPanel.this.conceptComboBox.requestFocus();
                    }
                }
            });
        }
        return this.conceptComboBox;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout(4, 4));
            this.jPanel.add((Component)this.getConceptComboBox(), "West");
            JScrollPane scrollPane = new JScrollPane(this.getNotesArea());
            this.jPanel.add((Component)scrollPane, "Center");
        }
        return this.jPanel;
    }

    private AssociationListEditorPanel getListPanel() {
        if (this.listPanel == null) {
            this.listPanel = new AssociationListEditorPanel(this.toolBelt);
            this.listPanel.setMinimumSize(new Dimension(200, 100));
        }
        return this.listPanel;
    }

    private Collection<String> getNotableConceptNames() {
        block4: {
            if (this.notableConceptNames == null) {
                this.notableConceptNames = new HashSet<String>();
                try {
                    Concept rootConcept = this.toolBelt.getAnnotationPersistenceService().findRootConcept();
                    this.notableConceptNames.add(rootConcept.getPrimaryConceptName().getName());
                    List chillin = rootConcept.getChildConcepts();
                    for (Concept child : chillin) {
                        this.notableConceptNames.add(child.getPrimaryConceptName().getName());
                    }
                }
                catch (Exception e) {
                    if (!this.log.isErrorEnabled()) break block4;
                    this.log.error("Failed to get root concept from database", (Throwable)e);
                }
            }
        }
        return this.notableConceptNames;
    }

    private JTextArea getNotesArea() {
        if (this.notesArea == null) {
            this.notesArea = new JTextArea(1, 1);
            this.notesArea.setToolTipText("Notes");
            this.notesArea.getInputMap().put(KeyStroke.getKeyStroke("tab"), this.nextFocusAction.getValue("Name"));
            this.notesArea.getInputMap().put(KeyStroke.getKeyStroke("shifttab"), this.prevFocusAction.getValue("Name"));
            this.notesArea.getActionMap().put(this.nextFocusAction.getValue("Name"), this.nextFocusAction);
            this.notesArea.getActionMap().put(this.prevFocusAction.getValue("Name"), this.prevFocusAction);
            this.notesArea.setFocusTraversalKeys(0, tab);
            this.notesArea.setFocusTraversalKeys(1, shifttab);
            this.notesArea.setWrapStyleWord(true);
            this.notesArea.setLineWrap(true);
            this.notesArea.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.update();
                }

                void update() {
                    if (RowEditorPanel.this.observation != null) {
                        RowEditorPanel.this.observation.setNotes(RowEditorPanel.this.getNotesArea().getText());
                    }
                }
            });
        }
        return this.notesArea;
    }

    public Observation getObservation() {
        return this.observation;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getJPanel(), "North");
        this.add((Component)this.getListPanel(), "Center");
        this.setEnabled(false);
        this.setFocusCycleRoot(true);
        Dimension size = this.getPreferredSize();
        Dimension preferredSize = new Dimension(size.height, 200);
        this.setPreferredSize(preferredSize);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

            @Override
            public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
                Component retval = super.getComponentAfter(focusCycleRoot, aComponent);
                if (retval == RowEditorPanel.this.notesArea) {
                    retval = this.getComponentAfter(focusCycleRoot, retval);
                }
                if (retval instanceof JList && RowEditorPanel.this.listPanel.getObservation().getAssociations().size() == 0) {
                    retval = this.getComponentAfter(focusCycleRoot, retval);
                }
                return retval;
            }
        });
    }

    @Override
    public void setEnabled(boolean shouldEnable) {
        super.setEnabled(shouldEnable);
        this.getNotesArea().setEnabled(shouldEnable);
        this.getListPanel().setEnabled(shouldEnable);
        this.getConceptComboBox().setEnabled(shouldEnable);
    }

    public void setObservation(Observation observation) {
        this.observation = observation;
        boolean isNull = observation == null;
        this.setEnabled(!isNull);
        this.getListPanel().setObservation(observation);
        if (isNull) {
            block4: {
                try {
                    ConceptDAO conceptDAO = this.toolBelt.getKnowledgebaseDAOFactory().newConceptDAO();
                    conceptDAO.startTransaction();
                    Concept rootConcept = conceptDAO.findRoot();
                    conceptDAO.endTransaction();
                    this.getConceptComboBox().setSelectedItem(rootConcept.getPrimaryConceptName().getName());
                }
                catch (Exception e) {
                    this.getConceptComboBox().setSelectedIndex(0);
                    if (!this.log.isErrorEnabled()) break block4;
                    this.log.error("Failed to find root concept in the KnowledgeBaseCache", (Throwable)e);
                }
            }
            this.getNotesArea().setText("");
            this.getNotesArea().setEnabled(false);
        } else {
            this.getConceptComboBox().setSelectedItem(observation.getConceptName());
            this.getNotesArea().setText(observation.getNotes());
            this.getNotesArea().setEnabled(!this.getNotableConceptNames().contains(observation.getConceptName()));
        }
        this.getConceptComboBox().requestFocus();
    }
}

