/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.roweditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.bushe.swing.event.EventBus;
import org.mbari.awt.event.ActionAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.LinkComparator;
import vars.annotation.Association;
import vars.annotation.Observation;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.commandqueue.CommandEvent;
import vars.annotation.ui.commandqueue.impl.RemoveAssociationsCmd;
import vars.annotation.ui.roweditor.AssociationEditorPanel;
import vars.annotation.ui.roweditor.AssociationListCellRenderer;
import vars.shared.ui.FancyButton;

public class AssociationListEditorPanel
extends JPanel {
    protected AssociationEditorPanel associationEditorPanel = null;
    private JButton buttonAdd = null;
    private JButton buttonEdit = null;
    private JButton buttonRemove = null;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    JPanel listEditorPanel = new JPanel();
    private ActionAdapter addAction;
    private JPanel buttonPanel;
    private ActionAdapter editAction;
    private boolean editingAssociation;
    JList jList;
    JScrollPane jScrollPane;
    private Observation observation;
    private ActionAdapter removeAction;
    private final ToolBelt toolBelt;

    public AssociationListEditorPanel(ToolBelt toolBelt) {
        this.toolBelt = toolBelt;
        this.initialize();
    }

    private void enableButtons() {
        this.getButtonAdd().setEnabled(this.observation != null);
        boolean enable = this.getJList().getSelectedIndex() != -1 && this.jList.getModel().getSize() != 0;
        this.getButtonRemove().setEnabled(enable);
        this.getButtonEdit().setEnabled(enable);
    }

    ActionAdapter getAddAction() {
        if (this.addAction == null) {
            this.addAction = new ActionAdapter(){

                public void doAction() {
                    try {
                        AssociationListEditorPanel.this.getAssociationEditorPanel().setTarget(AssociationListEditorPanel.this.observation, null);
                    }
                    catch (Exception ex) {
                        AssociationListEditorPanel.this.log.error("Failed to set target values in the AssociationEditorPanel", (Throwable)ex);
                    }
                    AssociationListEditorPanel.this.setEditingAssociation(true);
                }
            };
        }
        return this.addAction;
    }

    public AssociationEditorPanel getAssociationEditorPanel() {
        if (this.associationEditorPanel == null) {
            this.associationEditorPanel = new AssociationEditorPanel(this.toolBelt);
            this.associationEditorPanel.validate();
            this.associationEditorPanel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AssociationListEditorPanel.this.setEditingAssociation(false);
                }
            });
        }
        return this.associationEditorPanel;
    }

    private JButton getButtonAdd() {
        if (this.buttonAdd == null) {
            this.buttonAdd = new FancyButton();
            this.buttonAdd.setOpaque(false);
            this.buttonAdd.setPreferredSize(new Dimension(32, 32));
            this.buttonAdd.setToolTipText("Add Association");
            this.buttonAdd.setIcon(new ImageIcon(this.getClass().getResource("/images/vars/annotation/add.png")));
            this.buttonAdd.addActionListener((ActionListener)this.getAddAction());
        }
        return this.buttonAdd;
    }

    private JButton getButtonEdit() {
        if (this.buttonEdit == null) {
            this.buttonEdit = new FancyButton();
            this.buttonEdit.addActionListener((ActionListener)this.getEditAction());
            this.buttonEdit.setOpaque(false);
            this.buttonEdit.setPreferredSize(new Dimension(32, 32));
            this.buttonEdit.setToolTipText("Edit Association");
            this.buttonEdit.setIcon(new ImageIcon(this.getClass().getResource("/images/vars/annotation/edit.png")));
        }
        return this.buttonEdit;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
            this.buttonPanel.add(Box.createHorizontalGlue());
            this.buttonPanel.add(this.getButtonAdd());
            this.buttonPanel.add(this.getButtonEdit());
            this.buttonPanel.add(this.getButtonRemove());
        }
        return this.buttonPanel;
    }

    private JButton getButtonRemove() {
        if (this.buttonRemove == null) {
            this.buttonRemove = new FancyButton();
            this.buttonRemove.setOpaque(false);
            this.buttonRemove.setBackground(Color.red);
            this.buttonRemove.setPreferredSize(new Dimension(32, 32));
            this.buttonRemove.setToolTipText("Remove Association");
            this.buttonRemove.setIcon(new ImageIcon(this.getClass().getResource("/images/vars/annotation/remove.png")));
            this.buttonRemove.addActionListener((ActionListener)this.getRemoveAction());
        }
        return this.buttonRemove;
    }

    ActionAdapter getEditAction() {
        if (this.editAction == null) {
            this.editAction = new ActionAdapter(){

                public void doAction() {
                    try {
                        AssociationListEditorPanel.this.getAssociationEditorPanel().setTarget(AssociationListEditorPanel.this.observation, (Association)AssociationListEditorPanel.this.getJList().getSelectedValue());
                    }
                    catch (Exception ex) {
                        AssociationListEditorPanel.this.log.error("Failed to set values in the AssociationEditorPanel", (Throwable)ex);
                    }
                    AssociationListEditorPanel.this.setEditingAssociation(true);
                }
            };
        }
        return this.editAction;
    }

    private JList getJList() {
        if (this.jList == null) {
            this.jList = new JList(new DefaultListModel());
            this.jList.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent evt) {
                    JList list = (JList)evt.getComponent();
                    ListSelectionModel selModel = list.getSelectionModel();
                    if (selModel.isSelectionEmpty()) {
                        selModel.setAnchorSelectionIndex(0);
                        selModel.setLeadSelectionIndex(0);
                    }
                }
            });
            this.jList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    AssociationListEditorPanel.this.enableButtons();
                }
            });
            this.jList.setFocusable(true);
            this.jList.setSelectedIndex(0);
            this.jList.setSelectionMode(0);
            AssociationListCellRenderer rendererAssoList = new AssociationListCellRenderer();
            this.jList.setCellRenderer(rendererAssoList);
            ToolTipManager.sharedInstance().registerComponent(this.jList);
        }
        return this.jList;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane(20, 30);
            this.jScrollPane.getVerticalScrollBar().setFocusable(false);
            this.jScrollPane.getHorizontalScrollBar().setFocusable(false);
            this.jScrollPane.setViewportView(this.getJList());
        }
        return this.jScrollPane;
    }

    public Observation getObservation() {
        return this.observation;
    }

    ActionAdapter getRemoveAction() {
        if (this.removeAction == null) {
            this.removeAction = new ActionAdapter(){

                public void doAction() {
                    JList j = AssociationListEditorPanel.this.getJList();
                    if (j.getSelectedIndex() > -1) {
                        DefaultListModel listModel = (DefaultListModel)j.getModel();
                        final Association association = (Association)j.getSelectedValue();
                        if (association == null) {
                            listModel.remove(j.getSelectedIndex());
                            return;
                        }
                        listModel.remove(j.getSelectedIndex());
                        RemoveAssociationsCmd command = new RemoveAssociationsCmd((Collection<Association>)new ArrayList<Association>(){
                            {
                                this.add(association);
                            }
                        });
                        CommandEvent commandEvent = new CommandEvent(command);
                        EventBus.publish((Object)commandEvent);
                    }
                }
            };
        }
        return this.removeAction;
    }

    void initialize() {
        this.listEditorPanel.setOpaque(false);
        this.layoutPanel();
        this.setFocusable(false);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (AssociationListEditorPanel.this.getJList().getModel().getSize() == 0) {
                    AssociationListEditorPanel.this.getAddAction().doAction();
                }
            }
        });
    }

    public boolean isEditingAssociation() {
        return this.editingAssociation;
    }

    private void layoutPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getJScrollPane(), "Center");
        this.add((Component)this.getButtonPanel(), "South");
    }

    public void setEditingAssociation(boolean isEditingItem) {
        this.editingAssociation = isEditingItem;
        if (isEditingItem) {
            this.listEditorPanel.setVisible(false);
            this.removeAll();
            AssociationEditorPanel p = this.getAssociationEditorPanel();
            this.add((Component)p, "Center");
            p.setVisible(true);
            ((JComponent)p).setEnabled(true);
            p.setFocusable(true);
            p.requestFocus();
        } else {
            this.getAssociationEditorPanel().setVisible(false);
            this.remove(this.getAssociationEditorPanel());
            this.layoutPanel();
            this.listEditorPanel.setVisible(true);
            this.listEditorPanel.requestFocus();
        }
    }

    @Override
    public void setEnabled(boolean shouldEnable) {
        this.jList.setEnabled(shouldEnable);
        this.jScrollPane.setEnabled(shouldEnable);
        this.listEditorPanel.setEnabled(shouldEnable);
        if (shouldEnable) {
            this.enableButtons();
        } else {
            this.getButtonAdd().setEnabled(false);
            this.getButtonRemove().setEnabled(false);
            this.getButtonEdit().setEnabled(false);
        }
    }

    public void setObservation(Observation newObservation) {
        DefaultListModel listModel = (DefaultListModel)this.getJList().getModel();
        listModel.clear();
        if (newObservation != null) {
            ArrayList associations = new ArrayList(newObservation.getAssociations());
            Collections.sort(associations, new LinkComparator());
            for (Association association : associations) {
                listModel.addElement(association);
            }
        }
        this.observation = newObservation;
        this.enableButtons();
        this.setEditingAssociation(false);
        this.repaint();
    }

    @Override
    public void setVisible(boolean b) {
        this.getButtonEdit().setEnabled(false);
        this.getButtonRemove().setEnabled(false);
        this.getButtonAdd().setEnabled(false);
        super.setVisible(b);
    }
}

