/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.roweditor;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import vars.ILink;
import vars.LinkUtilities;
import vars.annotation.Association;

public class AssociationListCellRenderer
extends DefaultListCellRenderer {
    String assoString;

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value instanceof String) {
            this.setText((String)value);
            this.assoString = (String)value;
        } else {
            Association association = null;
            association = (Association)value;
            if (association != null) {
                this.assoString = LinkUtilities.formatAsLongString((ILink)association);
                this.setText(this.assoString);
            } else {
                this.assoString = "--No Association--";
                this.setText(this.assoString);
            }
        }
        return component;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        if (dim != null) {
            dim = new Dimension(dim.width + 4, dim.height);
        }
        return dim;
    }

    @Override
    public String getToolTipText() {
        return this.assoString;
    }
}

