/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.roweditor;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.bushe.swing.event.EventBus;
import vars.ILink;
import vars.annotation.Association;
import vars.annotation.Observation;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.commandqueue.CommandEvent;
import vars.annotation.ui.commandqueue.impl.AddAssociationCmd;
import vars.annotation.ui.commandqueue.impl.ChangeAssociationsCmd;
import vars.annotation.ui.roweditor.AssociationEditorPanel;

public class AssociationEditorPanelController {
    private Association association;
    private Observation observation;
    private final AssociationEditorPanel panel;
    private final ToolBelt toolBelt;

    public AssociationEditorPanelController(ToolBelt toolBelt, AssociationEditorPanel panel) {
        this.toolBelt = toolBelt;
        this.panel = panel;
    }

    public void setTarget(Observation observation, Association association) {
        this.observation = observation;
        this.association = association;
    }

    public Observation getObservation() {
        return this.observation;
    }

    public Association getAssociation() {
        return this.association;
    }

    public ToolBelt getToolBelt() {
        return this.toolBelt;
    }

    public void doOkay(ILink link) {
        if (this.association == null) {
            this.addAssociation(link);
        } else {
            this.updateAssociation(link);
        }
    }

    private void addAssociation(ILink link) {
        if (this.observation != null) {
            Association newAssociation = this.toolBelt.getAnnotationFactory().newAssociation(link.getLinkName(), link.getToConcept(), link.getLinkValue());
            AddAssociationCmd command = new AddAssociationCmd((ILink)newAssociation, (Collection<Observation>)ImmutableList.of((Object)this.observation));
            CommandEvent commandEvent = new CommandEvent(command);
            EventBus.publish((Object)commandEvent);
        }
        this.observation = null;
        this.association = null;
    }

    private void updateAssociation(ILink link) {
        if (this.association != null) {
            Association copyOfLink = this.toolBelt.getAnnotationFactory().newAssociation(link);
            ChangeAssociationsCmd command = new ChangeAssociationsCmd((ILink)copyOfLink, (Collection<Association>)ImmutableList.of((Object)this.association));
            CommandEvent commandEvent = new CommandEvent(command);
            EventBus.publish((Object)commandEvent);
        }
        this.observation = null;
        this.association = null;
    }
}

