/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.roweditor;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import foxtrot.Task;
import foxtrot.Worker;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.bushe.swing.event.EventBus;
import org.mbari.swing.LabeledSpinningDialWaitIndicator;
import org.mbari.swing.SearchableComboBoxModel;
import org.mbari.swing.SortedComboBoxModel;
import org.mbari.text.ObjectToStringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.ILink;
import vars.LinkBean;
import vars.LinkComparator;
import vars.LinkUtilities;
import vars.annotation.AnnotationPersistenceService;
import vars.annotation.Association;
import vars.annotation.Observation;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.roweditor.AssociationEditorPanelController;
import vars.knowledgebase.Concept;
import vars.knowledgebase.LinkTemplate;
import vars.shared.ui.FancyButton;
import vars.shared.ui.HierachicalConceptNameComboBox;
import vars.shared.ui.LinkListCellRenderer;

public class AssociationEditorPanel
extends JPanel {
    private final ILink nil = new LinkBean("nil", "nil", "nil");
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private JButton cancelButton;
    private final AssociationEditorPanelController controller;
    private JLabel lblLinkName;
    private JLabel lblSearchFor;
    private JLabel lblToConcept;
    private JLabel lblValue;
    private JTextField linkNameTextField;
    private JTextField linkValueTextField;
    private JComboBox linksComboBox;
    private JButton okButton;
    private JTextField searchTextField;
    private HierachicalConceptNameComboBox toConceptComboBox;

    public AssociationEditorPanel(ToolBelt toolBelt) {
        this.controller = new AssociationEditorPanelController(toolBelt, this);
        this.initialize();
    }

    public void addActionListener(ActionListener l) {
        this.getOkButton().addActionListener(l);
        this.getCancelButton().addActionListener(l);
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new FancyButton();
            this.cancelButton.setPreferredSize(new Dimension(30, 23));
            this.cancelButton.setToolTipText("Cancel");
            this.cancelButton.setIcon(new ImageIcon(this.getClass().getResource("/images/vars/annotation/stop.png")));
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AssociationEditorPanel.this.resetDisplay();
                }
            });
        }
        return this.cancelButton;
    }

    private JLabel getLblLinkName() {
        if (this.lblLinkName == null) {
            this.lblLinkName = new JLabel("Link");
        }
        return this.lblLinkName;
    }

    private JLabel getLblSearchFor() {
        if (this.lblSearchFor == null) {
            this.lblSearchFor = new JLabel("Search for: ");
        }
        return this.lblSearchFor;
    }

    private JLabel getLblToConcept() {
        if (this.lblToConcept == null) {
            this.lblToConcept = new JLabel("To");
        }
        return this.lblToConcept;
    }

    private JLabel getLblValue() {
        if (this.lblValue == null) {
            this.lblValue = new JLabel("Value");
        }
        return this.lblValue;
    }

    protected JTextField getLinkNameTextField() {
        if (this.linkNameTextField == null) {
            this.linkNameTextField = new JTextField();
            this.linkNameTextField.setColumns(10);
            this.linkNameTextField.setToolTipText("Link Name");
            this.linkNameTextField.setEditable(false);
            this.linkNameTextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    AssociationEditorPanel.this.linkNameTextField.setSelectionStart(0);
                    AssociationEditorPanel.this.linkNameTextField.setSelectionEnd(AssociationEditorPanel.this.linkNameTextField.getText().length());
                }
            });
        }
        return this.linkNameTextField;
    }

    protected JTextField getLinkValueTextField() {
        if (this.linkValueTextField == null) {
            this.linkValueTextField = new JTextField();
            this.linkValueTextField.setColumns(10);
            this.linkValueTextField.setToolTipText("Link Value");
            this.linkValueTextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    AssociationEditorPanel.this.linkValueTextField.setSelectionStart(0);
                    AssociationEditorPanel.this.linkValueTextField.setSelectionEnd(AssociationEditorPanel.this.linkValueTextField.getText().length());
                }
            });
        }
        return this.linkValueTextField;
    }

    protected JComboBox getLinksComboBox() {
        if (this.linksComboBox == null) {
            this.linksComboBox = new JComboBox();
            this.linksComboBox.setRenderer(new LinkListCellRenderer());
            this.linksComboBox.setModel(new SearchableComboBoxModel((Comparator)new LinkComparator(), (ObjectToStringConverter)new ObjectToStringConverter<ILink>(){

                public String convert(ILink object) {
                    return LinkUtilities.formatAsString((ILink)object);
                }
            }));
            this.linksComboBox.setToolTipText("Links in Knowledgebase");
            this.linksComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        AssociationEditorPanel.this.setLink((ILink)e.getItem());
                    }
                }
            });
        }
        return this.linksComboBox;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new FancyButton();
            this.okButton.setPreferredSize(new Dimension(30, 23));
            this.okButton.setIcon(new ImageIcon(this.getClass().getResource("/images/vars/annotation/add.png")));
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LinkBean link = new LinkBean(AssociationEditorPanel.this.getLinkNameTextField().getText(), (String)AssociationEditorPanel.this.getToConceptComboBox().getSelectedItem(), AssociationEditorPanel.this.getLinkValueTextField().getText());
                    AssociationEditorPanel.this.controller.doOkay((ILink)link);
                }
            });
        }
        return this.okButton;
    }

    private JTextField getSearchTextField() {
        if (this.searchTextField == null) {
            this.searchTextField = new JTextField();
            this.searchTextField.setColumns(10);
            this.searchTextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    AssociationEditorPanel.this.searchTextField.setSelectionStart(0);
                    AssociationEditorPanel.this.searchTextField.setSelectionEnd(AssociationEditorPanel.this.searchTextField.getText().length());
                }
            });
            this.searchTextField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index;
                    JComboBox comboBox = AssociationEditorPanel.this.getLinksComboBox();
                    SearchableComboBoxModel model = (SearchableComboBoxModel)comboBox.getModel();
                    int startIndex = comboBox.getSelectedIndex() + 1;
                    if (startIndex >= model.getSize()) {
                        startIndex = 0;
                    }
                    if ((index = model.searchForItemContaining(AssociationEditorPanel.this.searchTextField.getText(), startIndex)) > -1) {
                        comboBox.setSelectedIndex(index);
                        comboBox.hidePopup();
                    } else if (startIndex > 0 && (index = model.searchForItemContaining(AssociationEditorPanel.this.searchTextField.getText())) > -1) {
                        comboBox.setSelectedIndex(index);
                        comboBox.hidePopup();
                    }
                }
            });
        }
        return this.searchTextField;
    }

    private HierachicalConceptNameComboBox getToConceptComboBox() {
        if (this.toConceptComboBox == null) {
            this.toConceptComboBox = new HierachicalConceptNameComboBox(this.controller.getToolBelt().getAnnotationPersistenceService());
            this.toConceptComboBox.setToolTipText("To Concept");
            this.toConceptComboBox.addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    AssociationEditorPanel.this.toConceptComboBox.getEditor().selectAll();
                }
            });
        }
        return this.toConceptComboBox;
    }

    private void initialize() {
        GroupLayout groupLayout = new GroupLayout(this);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getLinksComboBox(), 0, 438, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.getLblSearchFor()).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getSearchTextField(), -1, 361, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getLblLinkName()).addComponent(this.getLblValue())).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.getLinkNameTextField(), -2, 202, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getLblToConcept()).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.getToConceptComboBox(), 0, 205, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addComponent(this.getLinkValueTextField(), -1, 154, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getOkButton()).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getCancelButton()))))).addGap(4)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getLblSearchFor()).addComponent(this.getSearchTextField(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getLinksComboBox(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getLblLinkName()).addComponent(this.getLinkNameTextField(), -2, -1, -2)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getLblToConcept()).addComponent((Component)this.getToConceptComboBox(), -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getLblValue()).addComponent(this.getLinkValueTextField(), -2, -1, -2).addComponent(this.getOkButton()).addComponent(this.getCancelButton())).addContainerGap(165, Short.MAX_VALUE)));
        this.setLayout(groupLayout);
        this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

            @Override
            public Component getComponentAfter(Container aContainer, Component aComponent) {
                Component componentAfter = AssociationEditorPanel.this.getOkButton();
                if (aComponent == AssociationEditorPanel.this.getOkButton()) {
                    componentAfter = AssociationEditorPanel.this.getCancelButton();
                }
                if (aComponent == AssociationEditorPanel.this.getCancelButton()) {
                    AssociationEditorPanel.this.setFocusCycleRoot(false);
                    componentAfter = AssociationEditorPanel.this.getFocusCycleRootAncestor().getFocusTraversalPolicy().getComponentAfter(AssociationEditorPanel.this.getFocusCycleRootAncestor(), AssociationEditorPanel.this);
                    AssociationEditorPanel.this.setFocusCycleRoot(true);
                }
                return componentAfter;
            }

            @Override
            public Component getComponentBefore(Container aContainer, Component aComponent) {
                Component componentBefore = AssociationEditorPanel.this.getSearchTextField();
                if (aComponent == AssociationEditorPanel.this.getSearchTextField()) {
                    AssociationEditorPanel.this.setFocusCycleRoot(false);
                    componentBefore = AssociationEditorPanel.this.getFocusCycleRootAncestor().getFocusTraversalPolicy().getComponentBefore(AssociationEditorPanel.this.getFocusCycleRootAncestor(), AssociationEditorPanel.this);
                    AssociationEditorPanel.this.setFocusCycleRoot(true);
                }
                if (aComponent == AssociationEditorPanel.this.getCancelButton()) {
                    componentBefore = AssociationEditorPanel.this.getOkButton();
                }
                return componentBefore;
            }

            @Override
            public Component getFirstComponent(Container aContainer) {
                return AssociationEditorPanel.this.getSearchTextField();
            }

            @Override
            public Component getLastComponent(Container aContainer) {
                return AssociationEditorPanel.this.getCancelButton();
            }

            @Override
            public Component getDefaultComponent(Container aContainer) {
                return AssociationEditorPanel.this.getSearchTextField();
            }
        });
        this.setFocusCycleRoot(true);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                AssociationEditorPanel.this.getRootPane().setDefaultButton(AssociationEditorPanel.this.getOkButton());
                AssociationEditorPanel.this.getSearchTextField().requestFocus();
            }
        });
        this.resetDisplay();
    }

    public void resetDisplay() {
        this.getSearchTextField().setText("");
        this.setLink(this.nil);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getCancelButton().setEnabled(enabled);
        this.getOkButton().setEnabled(enabled);
        this.getToConceptComboBox().setEnabled(enabled);
        this.getLinkNameTextField().setEnabled(enabled);
        this.getLinkValueTextField().setEnabled(enabled);
        this.getLinksComboBox().setEnabled(enabled);
    }

    private void setLink(final ILink link) {
        LabeledSpinningDialWaitIndicator waitIndicator = new LabeledSpinningDialWaitIndicator((JComponent)this, "Loading " + link.getToConcept() + " ...");
        this.getLinkNameTextField().setText(link.getLinkName());
        this.getLinkValueTextField().setText(link.getLinkValue());
        HierachicalConceptNameComboBox comboBox = this.getToConceptComboBox();
        comboBox.hidePopup();
        this.getLinksComboBox().hidePopup();
        String conceptName = link.getToConcept();
        if (conceptName.equals("nil") || conceptName.equals("self")) {
            SortedComboBoxModel model = (SortedComboBoxModel)comboBox.getModel();
            model.clear();
            model.addElement((Object)conceptName);
        } else {
            try {
                Concept c = (Concept)Worker.post((Task)new Task(){

                    public Object run() throws Exception {
                        return AssociationEditorPanel.this.controller.getToolBelt().getAnnotationPersistenceService().findConceptByName(link.getToConcept());
                    }
                });
                comboBox.setConcept(c);
                conceptName = c.getPrimaryConceptName().getName();
            }
            catch (Exception e) {
                EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
                comboBox.addItem((Object)conceptName);
            }
        }
        comboBox.setSelectedItem((Object)conceptName);
        waitIndicator.dispose();
        this.repaint();
    }

    public void setTarget(final Observation observation, final Association association) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AssociationEditorPanel.this.controller.setTarget(observation, association);
                ILink defaultLink = AssociationEditorPanel.this.nil;
                if (observation != null) {
                    if (association != null) {
                        defaultLink = association;
                        AssociationEditorPanel.this.getOkButton().setToolTipText("Accept Edits");
                    } else {
                        AssociationEditorPanel.this.getOkButton().setToolTipText("Add Association");
                    }
                }
                JComboBox comboBox = AssociationEditorPanel.this.getLinksComboBox();
                SearchableComboBoxModel model = (SearchableComboBoxModel)comboBox.getModel();
                model.clear();
                model.addElement((Object)AssociationEditorPanel.this.nil);
                AnnotationPersistenceService service = AssociationEditorPanel.this.controller.getToolBelt().getAnnotationPersistenceService();
                try {
                    Concept concept = service.findConceptByName(observation.getConceptName());
                    if (concept == null) {
                        AssociationEditorPanel.this.log.warn("A concept named" + observation.getConceptName() + " was not found in the knowledgebase");
                        concept = service.findRootConcept();
                    }
                    Collection linkTemplates = Collections2.transform((Collection)service.findLinkTemplatesFor(concept), (Function)new Function<LinkTemplate, ILink>(){

                        public ILink apply(LinkTemplate from) {
                            return from;
                        }
                    });
                    model.addAll(linkTemplates);
                }
                catch (Exception e) {
                    EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
                }
                if (!model.contains((Object)defaultLink)) {
                    model.addElement((Object)defaultLink);
                }
                comboBox.setSelectedItem(defaultLink);
                AssociationEditorPanel.this.setLink(defaultLink);
            }
        });
    }
}

