/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.preferences;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.PreferencesFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import vars.MiscDAOFactory;
import vars.UserAccount;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.preferences.ImagePreferencesPanel;
import vars.annotation.ui.preferences.UserPreferencesPanel;
import vars.annotation.ui.preferences.VideoConnectionPreferencesPanel;
import vars.shared.preferences.PreferenceUpdater;

public class PreferencesFrame
extends JFrame {
    private JButton okButton;
    private JButton cancelButton;
    private JPanel buttonPanel;
    private JTabbedPane tabbedPane;
    private ImagePreferencesPanel imagePreferencesPanel;
    private UserPreferencesPanel userPreferencesPanel;
    private VideoConnectionPreferencesPanel videoConnectionPreferencesPanel;
    private List<PreferenceUpdater> updaters = new ArrayList<PreferenceUpdater>();
    private final PreferencesFactory preferencesFactory;
    private UserAccount userAccount;

    @Inject
    public PreferencesFrame(PreferencesFactory preferencesFactory) {
        this.preferencesFactory = preferencesFactory;
        this.setBounds(100, 100, 500, 375);
        this.setDefaultCloseOperation(3);
        try {
            this.initialize();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void initialize() throws Exception {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getTabbedPane(), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.updaters.add(this.getImagePreferencesPanel());
        this.updaters.add(this.getUserPreferencesPanel());
        this.updaters.add(this.getVideoConnectionPreferencesPanel());
    }

    protected JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.addTab("Image Settings", this.getImagePreferencesPanel());
            this.tabbedPane.addTab("Account Information", this.getUserPreferencesPanel());
            this.tabbedPane.addTab("Video Connection", this.getVideoConnectionPreferencesPanel());
        }
        return this.tabbedPane;
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
            this.buttonPanel.add(Box.createHorizontalGlue());
            this.buttonPanel.add(this.getCancelButton());
            this.buttonPanel.add(Box.createHorizontalStrut(10));
            this.buttonPanel.add(this.getOkButton());
        }
        return this.buttonPanel;
    }

    protected JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new CancelAction());
        }
        return this.cancelButton;
    }

    protected JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("OK");
            this.okButton.addActionListener(new OKAction());
        }
        return this.okButton;
    }

    public ImagePreferencesPanel getImagePreferencesPanel() {
        if (this.imagePreferencesPanel == null) {
            this.imagePreferencesPanel = new ImagePreferencesPanel(this.preferencesFactory);
        }
        return this.imagePreferencesPanel;
    }

    public UserAccount getUserAccount() {
        return this.userAccount;
    }

    public void setUserAccount(UserAccount userAccount) {
        this.getImagePreferencesPanel().setUserAccount(userAccount);
        this.userAccount = userAccount;
    }

    public UserPreferencesPanel getUserPreferencesPanel() {
        if (this.userPreferencesPanel == null) {
            Injector injector = StateLookup.GUICE_INJECTOR;
            MiscDAOFactory daoFactory = (MiscDAOFactory)injector.getInstance(MiscDAOFactory.class);
            this.userPreferencesPanel = new UserPreferencesPanel(daoFactory);
        }
        return this.userPreferencesPanel;
    }

    public VideoConnectionPreferencesPanel getVideoConnectionPreferencesPanel() {
        if (this.videoConnectionPreferencesPanel == null) {
            this.videoConnectionPreferencesPanel = new VideoConnectionPreferencesPanel(this.preferencesFactory);
        }
        return this.videoConnectionPreferencesPanel;
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PreferencesFrame.this.setVisible(false);
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (PreferenceUpdater preferenceUpdater : PreferencesFrame.this.updaters) {
                preferenceUpdater.persistPreferences();
            }
            PreferencesFrame.this.setVisible(false);
        }
    }
}

