/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.preferences;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.prefs.PreferencesFactory;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.bushe.swing.event.EventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.UserAccount;
import vars.annotation.ui.eventbus.ImageInterpolationChangedEvent;
import vars.annotation.ui.preferences.ImagePreferencesPanel;
import vars.shared.awt.AWTUtilities;
import vars.shared.preferences.PreferenceUpdater;
import vars.shared.preferences.PreferencesService;

public class ImagePreferencesPanelController
implements PreferenceUpdater {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ImagePreferencesPanel panel;
    private final PreferencesService preferencesService;

    public ImagePreferencesPanelController(ImagePreferencesPanel panel, PreferencesFactory preferencesFactory) {
        this.panel = panel;
        this.preferencesService = new PreferencesService(preferencesFactory);
    }

    public void persistPreferences() {
        UserAccount userAccount = this.panel.getUserAccount();
        String username = userAccount.getUserName();
        String hostname = this.preferencesService.getHostname();
        JTextField imageTargetTextField = this.panel.getImageTargetTextField();
        JTextField imageTargetMappingTextField = this.panel.getImageTargetMappingTextField();
        JComboBox<String> imageInterpComboxBox = this.panel.getImageInterpComboBox();
        File imageTarget = new File(imageTargetTextField.getText());
        if (!imageTarget.exists() && !imageTarget.canWrite()) {
            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)("The location, " + imageTargetTextField.getText() + ", that you specified is not valid"));
        }
        this.preferencesService.persistImageTarget(username, hostname, imageTarget);
        URL imageMappingTarget = null;
        try {
            imageMappingTarget = new URL(imageTargetMappingTextField.getText());
        }
        catch (MalformedURLException ex) {
            this.log.warn("The user specified an invalid URL as an imageTarget. The bogus URL is '" + imageTargetMappingTextField.getText() + "'");
            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)("The location, " + imageTargetTextField.getText() + ", that you specified is not a valid URL"));
            return;
        }
        this.preferencesService.persistImageTargetMapping(username, hostname, imageMappingTarget);
        String interpHint = (String)imageInterpComboxBox.getSelectedItem();
        Object hint = AWTUtilities.IMAGE_INTERPOLATION_MAP.get(interpHint);
        if (hint != null) {
            this.preferencesService.persistImageInterpolation(username, hostname, hint);
            EventBus.publish((Object)new ImageInterpolationChangedEvent((Object)this, hint));
        }
    }

    protected void setUserAccount(UserAccount userAccount) {
        String username = userAccount.getUserName();
        String hostname = this.preferencesService.getHostname();
        File imageTarget = this.preferencesService.findImageTarget(username, hostname);
        URL imageTargetMapping = this.preferencesService.findImageTargetMapping(username, hostname);
        Object imageInterp = this.preferencesService.findImageInterpolation(username, hostname);
        try {
            this.panel.getImageTargetTextField().setText(imageTarget.getCanonicalPath());
        }
        catch (IOException ex) {
            this.panel.getImageTargetTextField().setText("");
        }
        this.panel.getImageTargetMappingTextField().setText(imageTargetMapping.toExternalForm());
        this.panel.getImageInterpComboBox().setSelectedItem(imageInterp.toString());
    }

    protected void persistDefaults() {
        JTextField imageTargetTextField = this.panel.getImageTargetTextField();
        File defaultImageTarget = new File(imageTargetTextField.getText());
        if (!defaultImageTarget.exists() && !defaultImageTarget.canWrite()) {
            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)("The location, " + imageTargetTextField.getText() + ", that you specified is not valid or does not exist"));
        }
        this.preferencesService.persistDefaultImageTarget(this.preferencesService.getHostname(), defaultImageTarget);
        JTextField imageTargetMappingTextField = this.panel.getImageTargetMappingTextField();
        URL imageMappingTarget = null;
        try {
            imageMappingTarget = new URL(imageTargetMappingTextField.getText());
        }
        catch (MalformedURLException ex) {
            this.log.warn("The user specified an invalid URL as an imageTarget. The bogus URL is '" + imageTargetMappingTextField.getText() + "'");
            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)("The location, " + imageTargetTextField.getText() + ", that you specified is not a valid URL"));
            return;
        }
        this.preferencesService.persistDefaultImageTargetMapping(this.preferencesService.getHostname(), imageMappingTarget);
    }
}

