/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.preferences;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.prefs.PreferencesFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.UserAccount;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.preferences.ImagePreferencesPanelController;
import vars.avplayer.ImageCaptureService;
import vars.avplayer.VideoController;
import vars.shared.awt.AWTUtilities;
import vars.shared.preferences.PreferenceUpdater;

public class ImagePreferencesPanel
extends JPanel
implements PreferenceUpdater {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private JButton browseButton;
    private JButton btnOpenVideoSettings;
    private final ImagePreferencesPanelController controller;
    private JComboBox imageFormatComboBox;
    private JLabel imageFormatLabel;
    private JTextField imageTargetMappingTextField;
    private JTextField imageTargetTextField;
    private JLabel imageWebAccessLabel;
    private JLabel saveImagesToLabel;
    private JLabel imageInterpLabel = new JLabel("Image Interpolation:");
    private JComboBox imageInterpComboBox;
    private JButton defaultsButton;
    private UserAccount userAccount;

    public ImagePreferencesPanel(PreferencesFactory preferencesFactory) {
        this.controller = new ImagePreferencesPanelController(this, preferencesFactory);
        try {
            this.initialize();
        }
        catch (Exception e) {
            this.log.warn("Failed to initialize!", (Throwable)e);
        }
    }

    protected JButton getBrowseButton() {
        if (this.browseButton == null) {
            this.browseButton = new JButton();
            this.browseButton.setText("Browse");
            this.browseButton.addActionListener(new BrowseAction());
        }
        return this.browseButton;
    }

    private JButton getBtnOpenVideoSettings() {
        if (this.btnOpenVideoSettings == null) {
            this.btnOpenVideoSettings = new JButton("Open Video Settings");
            this.btnOpenVideoSettings.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageCaptureService imageCaptureService;
                    VideoController videoController = StateLookup.getVideoController();
                    if (videoController != null && (imageCaptureService = videoController.getImageCaptureService()) != null) {
                        imageCaptureService.showSettingsDialog();
                    }
                }
            });
        }
        return this.btnOpenVideoSettings;
    }

    protected ImagePreferencesPanelController getController() {
        return this.controller;
    }

    protected JComboBox getImageFormatComboBox() {
        if (this.imageFormatComboBox == null) {
            this.imageFormatComboBox = new JComboBox();
            this.imageFormatComboBox.setEnabled(false);
        }
        return this.imageFormatComboBox;
    }

    protected JLabel getImageFormatLabel() {
        if (this.imageFormatLabel == null) {
            this.imageFormatLabel = new JLabel();
            this.imageFormatLabel.setText("Image Format:");
        }
        return this.imageFormatLabel;
    }

    protected JComboBox<String> getImageInterpComboBox() {
        if (this.imageInterpComboBox == null) {
            this.imageInterpComboBox = new JComboBox<Object>(AWTUtilities.IMAGE_INTERPOLATION_MAP.keySet().toArray());
            this.imageInterpComboBox.setSelectedIndex(0);
        }
        return this.imageInterpComboBox;
    }

    protected JTextField getImageTargetMappingTextField() {
        if (this.imageTargetMappingTextField == null) {
            this.imageTargetMappingTextField = new JTextField();
        }
        return this.imageTargetMappingTextField;
    }

    protected JTextField getImageTargetTextField() {
        if (this.imageTargetTextField == null) {
            this.imageTargetTextField = new JTextField();
        }
        return this.imageTargetTextField;
    }

    protected JLabel getImageWebAccessLabel() {
        if (this.imageWebAccessLabel == null) {
            this.imageWebAccessLabel = new JLabel();
            this.imageWebAccessLabel.setText("Image Web Access:");
        }
        return this.imageWebAccessLabel;
    }

    protected JLabel getSaveImagesToLabel() {
        if (this.saveImagesToLabel == null) {
            this.saveImagesToLabel = new JLabel();
            this.saveImagesToLabel.setText("Save Images to:");
        }
        return this.saveImagesToLabel;
    }

    private JButton getDefaultsButton() {
        if (this.defaultsButton == null) {
            this.defaultsButton = new JButton("Use as Defaults");
            this.defaultsButton.setToolTipText("Click this button to use these video settings as the defaults for all users on this computer");
            this.defaultsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImagePreferencesPanel.this.controller.persistDefaults();
                }
            });
        }
        return this.defaultsButton;
    }

    public UserAccount getUserAccount() {
        return this.userAccount;
    }

    private void initialize() throws Exception {
        GroupLayout groupLayout = new GroupLayout(this);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getBtnOpenVideoSettings()).addComponent(this.getDefaultsButton()).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getImageWebAccessLabel()).addComponent(this.getSaveImagesToLabel()).addComponent(this.getImageFormatLabel()).addComponent(this.imageInterpLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.getImageTargetTextField(), -1, 211, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getBrowseButton())).addComponent(this.getImageTargetMappingTextField(), -1, 305, Short.MAX_VALUE).addComponent(this.getImageFormatComboBox(), 0, 305, Short.MAX_VALUE).addComponent(this.getImageInterpComboBox(), 0, 305, Short.MAX_VALUE)))).addComponent(this.getDefaultsButton()).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getSaveImagesToLabel()).addComponent(this.getBrowseButton()).addComponent(this.getImageTargetTextField(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getImageWebAccessLabel()).addComponent(this.getImageTargetMappingTextField(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getImageFormatLabel()).addComponent(this.getImageFormatComboBox(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.imageInterpLabel).addComponent(this.getImageInterpComboBox(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 94, Short.MAX_VALUE).addComponent(this.getDefaultsButton()).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getBtnOpenVideoSettings()).addContainerGap()));
        this.setLayout(groupLayout);
    }

    public void persistPreferences() {
        this.controller.persistPreferences();
    }

    public void setUserAccount(UserAccount userAccount) {
        this.userAccount = userAccount;
        this.controller.setUserAccount(userAccount);
    }

    public void updatePreferences() {
        this.controller.persistPreferences();
    }

    private class BrowseAction
    implements ActionListener {
        final JFileChooser chooser = new JFileChooser();

        public BrowseAction() {
            this.chooser.setFileSelectionMode(1);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int response = this.chooser.showOpenDialog(ImagePreferencesPanel.this);
            if (response == 0) {
                File file = this.chooser.getSelectedFile();
                ImagePreferencesPanel.this.getImageTargetTextField().setText(file.getAbsolutePath());
            }
        }
    }
}

