/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.ppanel;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.bushe.swing.event.EventBus;
import org.mbari.awt.AwtUtilities;
import org.mbari.swing.LabeledSpinningDialWaitIndicator;
import org.mbari.swing.SearchableComboBoxModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.ILink;
import vars.LinkComparator;
import vars.LinkUtilities;
import vars.UserAccount;
import vars.annotation.Association;
import vars.annotation.CameraDirections;
import vars.annotation.Observation;
import vars.annotation.VideoArchive;
import vars.annotation.VideoArchiveDAO;
import vars.annotation.VideoFrame;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.actions.MoveVideoFrameWithDialogAction;
import vars.annotation.ui.commandqueue.CommandEvent;
import vars.annotation.ui.commandqueue.impl.AddAssociationCmd;
import vars.annotation.ui.commandqueue.impl.ChangeAssociationsCmd;
import vars.annotation.ui.commandqueue.impl.ChangeCameraDirectionsCmd;
import vars.annotation.ui.commandqueue.impl.RemoveAssociationsCmd;
import vars.annotation.ui.commandqueue.impl.RemoveObservationsCmd;
import vars.annotation.ui.commandqueue.impl.RenameObservationsCmd;
import vars.annotation.ui.ppanel.VideoArchiveEditorPanel;
import vars.annotation.ui.table.JXObservationTable;
import vars.annotation.ui.table.ObservationTableModel;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptDAO;
import vars.knowledgebase.LinkTemplateDAO;
import vars.shared.ui.LinkSelectionPanel;
import vars.shared.ui.dialogs.ConceptNameSelectionDialog;
import vars.shared.ui.dialogs.StandardDialog;

public class VideoArchivePanelController {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private AssociationSelectionDialog addAssociationDialog;
    private final MoveVideoFrameWithDialogAction moveAction;
    private final VideoArchiveEditorPanel panel;
    private AssociationSelectionDialog removeAssociationsDialog;
    private AssociationSelectionDialog renameAssociationsDialog;
    private ConceptNameSelectionDialog renameObservationsDialog;
    private final ToolBelt toolBelt;

    public VideoArchivePanelController(VideoArchiveEditorPanel panel, ToolBelt toolBelt) {
        this.panel = panel;
        this.toolBelt = toolBelt;
        this.moveAction = new MoveVideoFrameWithDialogAction(AwtUtilities.getFrame((Component)panel), toolBelt, true);
    }

    protected void addAssociation() {
        Collection<ILink> linkTemplates = this.findLinkTemplatesForObservations(this.getObservations(true));
        AssociationSelectionDialog dialog = this.getAddAssociationDialog();
        dialog.setLinks(linkTemplates);
        dialog.setVisible(true);
    }

    protected void changeCameraDirectionsTo(CameraDirections direction) {
        Collection<Observation> observations = this.getObservations(true);
        if (observations.size() < 1) {
            return;
        }
        HashSet<VideoFrame> videoFrames = new HashSet<VideoFrame>(Collections2.transform(observations, (Function)new Function<Observation, VideoFrame>(){

            public VideoFrame apply(Observation from) {
                return from.getVideoFrame();
            }
        }));
        Object[] options = new Object[]{"OK", "CANCEL"};
        int confirm = JOptionPane.showOptionDialog(AwtUtilities.getFrame((Component)this.panel), "Do you want to change the camera direction to '" + direction.getDirection() + "' for the " + videoFrames.size() + " selected video-frames(s)?", "VARS - Confirm Delete", -1, 2, null, options, options[0]);
        if (confirm == 0) {
            ChangeCameraDirectionsCmd command = new ChangeCameraDirectionsCmd(direction.getDirection(), videoFrames);
            CommandEvent commandEvent = new CommandEvent(command);
            EventBus.publish((Object)commandEvent);
        }
    }

    protected void deleteObservations() {
        Collection<Observation> observations = this.getObservations(true);
        int count = observations.size();
        if (observations.size() < 1) {
            return;
        }
        Object[] options = new Object[]{"OK", "CANCEL"};
        int confirm = JOptionPane.showOptionDialog(AwtUtilities.getFrame((Component)this.panel), "Do you want to delete " + count + " observation(s)?", "VARS - Confirm Delete", -1, 2, null, options, options[0]);
        if (confirm == 0) {
            RemoveObservationsCmd command = new RemoveObservationsCmd(observations);
            CommandEvent commandEvent = new CommandEvent(command);
            EventBus.publish((Object)commandEvent);
        }
    }

    private Collection<ILink> findLinkTemplatesForObservations(Collection<Observation> observations) {
        HashSet<ILink> linkTemplates = new HashSet<ILink>();
        ArrayList<String> conceptNames = new ArrayList<String>();
        LinkTemplateDAO linkTemplateDAO = this.toolBelt.getKnowledgebaseDAOFactory().newLinkTemplateDAO();
        ConceptDAO conceptDAO = this.toolBelt.getKnowledgebaseDAOFactory().newConceptDAO(linkTemplateDAO.getEntityManager());
        linkTemplateDAO.startTransaction();
        for (Observation observation : observations) {
            if (conceptNames.contains(observation.getConceptName())) continue;
            Concept concept = conceptDAO.findByName(observation.getConceptName());
            if (concept != null) {
                linkTemplates.addAll(linkTemplateDAO.findAllApplicableToConcept(concept));
            } else {
                this.log.debug("Unable to find Concept named '" + observation.getConceptName() + "' in the knowledgebase");
            }
            conceptNames.add(observation.getConceptName());
        }
        linkTemplateDAO.endTransaction();
        return linkTemplates;
    }

    private AssociationSelectionDialog getAddAssociationDialog() {
        if (this.addAssociationDialog == null) {
            this.addAssociationDialog = new AssociationSelectionDialog();
            this.addAssociationDialog.setTitle("VARS - Add an Association");
            this.addAssociationDialog.getCancelButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VideoArchivePanelController.this.addAssociationDialog.dispose();
                }
            });
            this.addAssociationDialog.getOkayButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ILink link = VideoArchivePanelController.this.addAssociationDialog.getLink();
                    Collection<Observation> observations = VideoArchivePanelController.this.getObservations(true);
                    AddAssociationCmd command = new AddAssociationCmd(link, observations);
                    CommandEvent commandEvent = new CommandEvent(command);
                    VideoArchivePanelController.this.addAssociationDialog.dispose();
                    EventBus.publish((Object)commandEvent);
                }
            });
        }
        return this.addAssociationDialog;
    }

    protected Collection<Association> getAssociations(boolean useSelectedOnly) {
        ArrayList<Association> associations = new ArrayList<Association>();
        for (Observation observation : this.getObservations(useSelectedOnly)) {
            associations.addAll(observation.getAssociations());
        }
        return associations;
    }

    protected Collection<Association> getFilteredAssocations(boolean useSelectedOnly, final ILink matcher) {
        return Collections2.filter(this.getAssociations(useSelectedOnly), (Predicate)new Predicate<Association>(){

            public boolean apply(Association input) {
                boolean match = true;
                if (!matcher.getLinkName().equalsIgnoreCase("nil")) {
                    match = input.getLinkName().equals(matcher.getLinkName());
                }
                if (match && !matcher.getToConcept().equalsIgnoreCase("nil")) {
                    match = input.getToConcept().equals(matcher.getToConcept());
                }
                if (match && !matcher.getLinkValue().equalsIgnoreCase("nil")) {
                    match = input.getLinkValue().equals(matcher.getLinkValue());
                }
                return match;
            }
        });
    }

    protected Collection<Observation> getObservations(boolean useSelectedOnly) {
        ArrayList<Observation> observations = new ArrayList<Observation>();
        JXObservationTable myTable = (JXObservationTable)StateLookup.getObservationTable();
        ObservationTableModel model = (ObservationTableModel)((Object)myTable.getModel());
        if (useSelectedOnly) {
            int[] rows;
            for (int i : rows = myTable.getSelectedRows()) {
                int modelRow = myTable.convertRowIndexToModel(i);
                Observation observation = model.getObservationAt(modelRow);
                observations.add(observation);
            }
        } else {
            int n = model.getNumberOfObservations();
            for (int i = 0; i < n; ++i) {
                observations.add(model.getObservationAt(i));
            }
        }
        return observations;
    }

    private AssociationSelectionDialog getRemoveAssociationsDialog() {
        if (this.removeAssociationsDialog == null) {
            this.removeAssociationsDialog = new AssociationSelectionDialog();
            this.removeAssociationsDialog.getOkayButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ILink link = VideoArchivePanelController.this.removeAssociationsDialog.getLink();
                    Collection<Association> associations = VideoArchivePanelController.this.getFilteredAssocations(true, link);
                    Object[] options = new Object[]{"OK", "CANCEL"};
                    int confirm = JOptionPane.showOptionDialog(AwtUtilities.getFrame((Component)VideoArchivePanelController.this.panel), "Do you want to delete " + associations.size() + " association(s)?", "VARS - Confirm Delete", -1, 2, null, options, options[0]);
                    VideoArchivePanelController.this.removeAssociationsDialog.dispose();
                    if (confirm == 0) {
                        RemoveAssociationsCmd command = new RemoveAssociationsCmd(associations);
                        CommandEvent commandEvent = new CommandEvent(command);
                        EventBus.publish((Object)commandEvent);
                    }
                }
            });
            this.removeAssociationsDialog.getCancelButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VideoArchivePanelController.this.removeAssociationsDialog.dispose();
                }
            });
        }
        return this.removeAssociationsDialog;
    }

    private AssociationSelectionDialog getRenameAssociationsDialog() {
        if (this.renameAssociationsDialog == null) {
            this.renameAssociationsDialog = new AssociationSelectionDialog();
            this.renameAssociationsDialog.getCancelButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VideoArchivePanelController.this.renameAssociationsDialog.dispose();
                }
            });
            this.renameAssociationsDialog.getOkayButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ILink match = (ILink)VideoArchivePanelController.this.panel.getAssociationComboBox().getSelectedItem();
                    Collection<Association> associations = VideoArchivePanelController.this.getFilteredAssocations(true, match);
                    ILink newLink = VideoArchivePanelController.this.renameAssociationsDialog.getLink();
                    VideoArchivePanelController.this.renameAssociationsDialog.dispose();
                    ChangeAssociationsCmd command = new ChangeAssociationsCmd(newLink, associations);
                    CommandEvent commandEvent = new CommandEvent(command);
                    EventBus.publish((Object)commandEvent);
                }
            });
        }
        return this.renameAssociationsDialog;
    }

    private ConceptNameSelectionDialog getRenameObservationsDialog() {
        if (this.renameObservationsDialog == null) {
            this.renameObservationsDialog = new ConceptNameSelectionDialog();
            this.renameObservationsDialog.getCancelButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VideoArchivePanelController.this.renameObservationsDialog.dispose();
                }
            });
            this.renameObservationsDialog.getOkayButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String name = VideoArchivePanelController.this.renameObservationsDialog.getSelectedItem();
                    VideoArchivePanelController.this.renameObservationsDialog.dispose();
                    Collection<Observation> observations = VideoArchivePanelController.this.getObservations(true);
                    UserAccount userAccount = StateLookup.getUserAccount();
                    String user = userAccount == null ? "default" : userAccount.getUserName();
                    RenameObservationsCmd command = new RenameObservationsCmd(name, user, observations);
                    CommandEvent commandEvent = new CommandEvent(command);
                    EventBus.publish((Object)commandEvent);
                }
            });
            this.renameObservationsDialog.setItems((Collection)this.toolBelt.getQueryPersistenceService().findAllConceptNamesAsStrings());
        }
        return this.renameObservationsDialog;
    }

    protected Collection<VideoFrame> getVideoFrames(boolean useSelectedOnly) {
        HashSet<VideoFrame> videoFrames = new HashSet<VideoFrame>();
        for (Observation observation : this.getObservations(useSelectedOnly)) {
            videoFrames.add(observation.getVideoFrame());
        }
        return videoFrames;
    }

    protected void moveObservations() {
        Collection<VideoFrame> videoFrames = this.getVideoFrames(true);
        this.moveAction.setVideoFrames(videoFrames);
        this.moveAction.doAction();
    }

    protected void refresh() {
        LabeledSpinningDialWaitIndicator waitIndicator = new LabeledSpinningDialWaitIndicator((JComponent)this.panel, "Refreshing ...");
        VideoArchive videoArchive = StateLookup.getVideoArchive();
        if (videoArchive != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Retrieving all video frames for " + videoArchive);
            }
            VideoArchiveDAO dao = this.toolBelt.getAnnotationDAOFactory().newVideoArchiveDAO();
            dao.startTransaction();
            videoArchive = (VideoArchive)dao.find((Object)videoArchive);
            HashSet<String> names = new HashSet<String>();
            HashSet associations = new HashSet();
            List videoFrames = videoArchive.getVideoFrames();
            for (VideoFrame videoFrame : videoFrames) {
                ImmutableList observations = ImmutableList.copyOf((Collection)videoFrame.getObservations());
                for (Observation observation : observations) {
                    names.add(observation.getConceptName());
                    associations.addAll(observation.getAssociations());
                }
            }
            dao.endTransaction();
            dao.close();
            String[] namesArray = new String[names.size()];
            names.toArray(namesArray);
            this.panel.getConceptComboBox().updateModel(namesArray);
            SearchableComboBoxModel model = (SearchableComboBoxModel)this.panel.getAssociationComboBox().getModel();
            model.clear();
            model.addAll(associations);
        }
        waitIndicator.dispose();
    }

    protected void removeAssociations() {
        Collection<Observation> observations = this.getObservations(true);
        HashSet associations = new HashSet();
        for (Observation observation : observations) {
            associations.addAll(observation.getAssociations());
        }
        Collection links = Collections2.transform(associations, (Function)new Function<Association, ILink>(){

            public ILink apply(Association from) {
                return from;
            }
        });
        AssociationSelectionDialog dialog = this.getRemoveAssociationsDialog();
        dialog.setTitle("VARS - Select association to delete");
        dialog.setLinks(links);
        dialog.setVisible(true);
    }

    protected void renameAssociations() {
        Collection<ILink> linkTemplates = this.findLinkTemplatesForObservations(this.getObservations(true));
        ILink link = (ILink)this.panel.getAssociationComboBox().getSelectedItem();
        AssociationSelectionDialog dialog = this.getRenameAssociationsDialog();
        dialog.setTitle("VARS - Replace " + LinkUtilities.formatAsString((ILink)link) + " with:");
        dialog.setLinks(linkTemplates);
        dialog.setVisible(true);
    }

    protected void renameObservations() {
        ConceptNameSelectionDialog dialog = this.getRenameObservationsDialog();
        dialog.setVisible(true);
    }

    protected void search() {
        Collection observations = this.getObservations(false);
        if (this.panel.getChckbxConcept().isSelected()) {
            final String conceptName = (String)this.panel.getConceptComboBox().getSelectedItem();
            observations = Collections2.filter(observations, (Predicate)new Predicate<Observation>(){

                public boolean apply(Observation input) {
                    return input.getConceptName().equals(conceptName);
                }
            });
        }
        if (this.panel.getChckbxAssociation().isSelected()) {
            final ILink link = (ILink)this.panel.getAssociationComboBox().getSelectedItem();
            observations = Collections2.filter((Collection)observations, (Predicate)new Predicate<Observation>(){
                LinkComparator linkComparator = new LinkComparator();

                public boolean apply(Observation input) {
                    boolean ok = false;
                    for (Association association : input.getAssociations()) {
                        if (this.linkComparator.compare(link, (ILink)association) != 0) continue;
                        ok = true;
                        break;
                    }
                    return ok;
                }
            });
        }
        this.selectObservations(observations);
    }

    protected void selectObservations(Collection<Observation> observations) {
        JXObservationTable myTable = (JXObservationTable)StateLookup.getObservationTable();
        Collection<Observation> allObservations = this.getObservations(false);
        allObservations.retainAll(observations);
        myTable.setSelectedObservations(allObservations);
    }

    private class AssociationSelectionDialog
    extends StandardDialog {
        private LinkSelectionPanel linkSelectionPanel;

        public AssociationSelectionDialog() {
            super(AwtUtilities.getFrame((Component)VideoArchivePanelController.this.panel), "VARS - Select Association", true);
            this.linkSelectionPanel = new LinkSelectionPanel(VideoArchivePanelController.this.toolBelt.getAnnotationPersistenceService());
            this.add((Component)this.linkSelectionPanel, "Center");
            this.pack();
        }

        public void allowEditing(boolean b) {
            this.linkSelectionPanel.getLinkValueTextField().setEditable(b);
            this.linkSelectionPanel.getToConceptComboBox().setEnabled(b);
        }

        public ILink getLink() {
            return this.linkSelectionPanel.getLink();
        }

        public void setLinks(Collection<ILink> links) {
            this.linkSelectionPanel.setLinks(links);
        }
    }
}

