/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.ppanel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Comparator;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.mbari.swing.SearchableComboBoxModel;
import org.mbari.text.ObjectToStringConverter;
import vars.ILink;
import vars.LinkBean;
import vars.LinkComparator;
import vars.LinkUtilities;
import vars.annotation.CameraDirections;
import vars.annotation.ui.CameraDirectionComboBox;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.eventbus.ObservationsAddedEvent;
import vars.annotation.ui.eventbus.ObservationsChangedEvent;
import vars.annotation.ui.eventbus.ObservationsRemovedEvent;
import vars.annotation.ui.eventbus.ObservationsSelectedEvent;
import vars.annotation.ui.eventbus.UIEventSubscriber;
import vars.annotation.ui.eventbus.VideoArchiveChangedEvent;
import vars.annotation.ui.eventbus.VideoArchiveSelectedEvent;
import vars.annotation.ui.eventbus.VideoFramesChangedEvent;
import vars.annotation.ui.ppanel.VideoArchivePanelController;
import vars.shared.ui.ConceptNameComboBox;
import vars.shared.ui.LinkListCellRenderer;

public class VideoArchiveEditorPanel
extends JPanel
implements UIEventSubscriber {
    private JPanel actionPanel;
    private JComboBox associationComboBox;
    private JButton btnAddAssociation;
    private JButton btnDelete;
    private JButton btnMoveFrames;
    private JButton btnRefresh;
    private ImageIcon needsRefreshIcon = new ImageIcon(this.getClass().getResource("/images/vars/annotation/refresh-red.png"));
    private ImageIcon noRefreshIcon = new ImageIcon(this.getClass().getResource("/images/vars/annotation/refresh-green.png"));
    private JButton btnRemoveAssociations;
    private JButton btnRenameConcepts;
    private JButton btnReplaceAssociations;
    private JButton btnSearch;
    private JComboBox cameraDirectionCB;
    private JCheckBox chckbxAssociation;
    private JCheckBox chckbxConcept;
    private ConceptNameComboBox conceptComboBox;
    private final VideoArchivePanelController controller;
    private JPanel controlsPanel;
    private JPanel searchPanel;
    private JToolBar toolBar;
    private JLabel refreshLabel = new JLabel("                                                                    ");

    public VideoArchiveEditorPanel(ToolBelt toolBelt) {
        this.initialize();
        this.refreshLabel.setForeground(Color.RED);
        this.controller = new VideoArchivePanelController(this, toolBelt);
        AnnotationProcessor.process((Object)this);
    }

    private JPanel getActionPanel() {
        if (this.actionPanel == null) {
            this.actionPanel = new JPanel();
            this.actionPanel.setLayout(new FlowLayout(1, 5, 5));
        }
        return this.actionPanel;
    }

    public JComboBox getAssociationComboBox() {
        if (this.associationComboBox == null) {
            this.associationComboBox = new JComboBox();
            this.associationComboBox.setRenderer(new LinkListCellRenderer());
            SearchableComboBoxModel model = new SearchableComboBoxModel((Comparator)new LinkComparator(), (ObjectToStringConverter)new ObjectToStringConverter<ILink>(){

                public String convert(ILink object) {
                    return LinkUtilities.formatAsString((ILink)object);
                }
            });
            this.associationComboBox.setModel(model);
            LinkBean link = new LinkBean("nil", "nil", "nil");
            model.addElement((Object)link);
            this.associationComboBox.setSelectedItem(link);
        }
        return this.associationComboBox;
    }

    private JButton getBtnAddAssociation() {
        if (this.btnAddAssociation == null) {
            this.btnAddAssociation = new JButton("");
            this.btnAddAssociation.setToolTipText("Add Association");
            this.btnAddAssociation.setIcon(new ImageIcon(this.getClass().getResource("/images/vars/annotation/branch_add.png")));
            this.btnAddAssociation.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VideoArchiveEditorPanel.this.controller.addAssociation();
                }
            });
        }
        return this.btnAddAssociation;
    }

    private JButton getBtnDelete() {
        if (this.btnDelete == null) {
            this.btnDelete = new JButton("");
            this.btnDelete.setToolTipText("Delete Observations");
            this.btnDelete.setIcon(new ImageIcon(this.getClass().getResource("/images/vars/annotation/row_delete.png")));
            this.btnDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VideoArchiveEditorPanel.this.controller.deleteObservations();
                }
            });
        }
        return this.btnDelete;
    }

    private JButton getBtnMoveFrames() {
        if (this.btnMoveFrames == null) {
            this.btnMoveFrames = new JButton("");
            this.btnMoveFrames.setToolTipText("Move Frames");
            this.btnMoveFrames.setIcon(new ImageIcon(this.getClass().getResource("/images/vars/annotation/row_replace.png")));
            this.btnMoveFrames.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VideoArchiveEditorPanel.this.controller.moveObservations();
                }
            });
        }
        return this.btnMoveFrames;
    }

    private JButton getBtnRefresh() {
        if (this.btnRefresh == null) {
            this.btnRefresh = new JButton("");
            this.btnRefresh.setToolTipText("Refresh");
            this.btnRefresh.setIcon(new ImageIcon(this.getClass().getResource("/images/vars/annotation/refresh.png")));
            this.btnRefresh.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VideoArchiveEditorPanel.this.refresh();
                }
            });
        }
        return this.btnRefresh;
    }

    private JButton getBtnRemoveAssociations() {
        if (this.btnRemoveAssociations == null) {
            this.btnRemoveAssociations = new JButton("");
            this.btnRemoveAssociations.setToolTipText("Remove Associations");
            this.btnRemoveAssociations.setIcon(new ImageIcon(this.getClass().getResource("/images/vars/annotation/branch_delete.png")));
            this.btnRemoveAssociations.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VideoArchiveEditorPanel.this.controller.removeAssociations();
                }
            });
        }
        return this.btnRemoveAssociations;
    }

    private JButton getBtnRenameConcepts() {
        if (this.btnRenameConcepts == null) {
            this.btnRenameConcepts = new JButton("");
            this.btnRenameConcepts.setToolTipText("Rename Observations");
            this.btnRenameConcepts.setIcon(new ImageIcon(this.getClass().getResource("/images/vars/annotation/row_edit.png")));
            this.btnRenameConcepts.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VideoArchiveEditorPanel.this.controller.renameObservations();
                }
            });
        }
        return this.btnRenameConcepts;
    }

    private JButton getBtnReplaceAssociations() {
        if (this.btnReplaceAssociations == null) {
            this.btnReplaceAssociations = new JButton("");
            this.btnReplaceAssociations.setToolTipText("Replace Associations");
            this.btnReplaceAssociations.setIcon(new ImageIcon(this.getClass().getResource("/images/vars/annotation/branch_edit.png")));
            this.btnReplaceAssociations.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VideoArchiveEditorPanel.this.controller.renameAssociations();
                }
            });
        }
        return this.btnReplaceAssociations;
    }

    private JButton getBtnSearch() {
        if (this.btnSearch == null) {
            this.btnSearch = new JButton("Search");
            this.btnSearch.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VideoArchiveEditorPanel.this.controller.search();
                }
            });
        }
        return this.btnSearch;
    }

    private JComboBox getCameraDirectionCB() {
        if (this.cameraDirectionCB == null) {
            this.cameraDirectionCB = new CameraDirectionComboBox();
            this.cameraDirectionCB.setToolTipText("Change the camera direction of the selected video-frames");
            this.cameraDirectionCB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        VideoArchiveEditorPanel.this.controller.changeCameraDirectionsTo((CameraDirections)VideoArchiveEditorPanel.this.cameraDirectionCB.getSelectedItem());
                    }
                }
            });
        }
        return this.cameraDirectionCB;
    }

    protected JCheckBox getChckbxAssociation() {
        if (this.chckbxAssociation == null) {
            this.chckbxAssociation = new JCheckBox("Association");
        }
        return this.chckbxAssociation;
    }

    protected JCheckBox getChckbxConcept() {
        if (this.chckbxConcept == null) {
            this.chckbxConcept = new JCheckBox("Concept");
        }
        return this.chckbxConcept;
    }

    protected ConceptNameComboBox getConceptComboBox() {
        if (this.conceptComboBox == null) {
            this.conceptComboBox = new ConceptNameComboBox();
        }
        return this.conceptComboBox;
    }

    private JPanel getControlsPanel() {
        if (this.controlsPanel == null) {
            this.controlsPanel = new JPanel();
            this.controlsPanel.setLayout(new BoxLayout(this.controlsPanel, 0));
            this.controlsPanel.add(this.getSearchPanel());
            this.controlsPanel.add(this.getActionPanel());
        }
        return this.controlsPanel;
    }

    private JPanel getSearchPanel() {
        if (this.searchPanel == null) {
            this.searchPanel = new JPanel();
            GroupLayout gl_searchPanel = new GroupLayout(this.searchPanel);
            gl_searchPanel.setHorizontalGroup(gl_searchPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_searchPanel.createSequentialGroup().addContainerGap().addGroup(gl_searchPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_searchPanel.createSequentialGroup().addGroup(gl_searchPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getChckbxAssociation()).addComponent(this.getChckbxConcept())).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_searchPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.getConceptComboBox(), 0, 309, Short.MAX_VALUE).addComponent(this.getAssociationComboBox(), 0, 309, Short.MAX_VALUE))).addComponent(this.getBtnSearch(), GroupLayout.Alignment.TRAILING)).addContainerGap()));
            gl_searchPanel.setVerticalGroup(gl_searchPanel.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(gl_searchPanel.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(gl_searchPanel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getChckbxConcept()).addComponent((Component)this.getConceptComboBox(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_searchPanel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getChckbxAssociation()).addComponent(this.getAssociationComboBox(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getBtnSearch())));
            this.searchPanel.setLayout(gl_searchPanel);
        }
        return this.searchPanel;
    }

    private JToolBar getToolBar() {
        if (this.toolBar == null) {
            this.toolBar = new JToolBar();
            this.toolBar.add(this.getBtnRefresh());
            this.toolBar.add(this.getBtnMoveFrames());
            this.toolBar.add(this.getBtnRenameConcepts());
            this.toolBar.add(this.getBtnDelete());
            this.toolBar.add(this.getBtnAddAssociation());
            this.toolBar.add(this.getBtnReplaceAssociations());
            this.toolBar.add(this.getBtnRemoveAssociations());
            this.toolBar.add(this.getCameraDirectionCB());
        }
        return this.toolBar;
    }

    protected void initialize() {
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.getToolBar(), "North");
        this.add((Component)this.getControlsPanel(), "Center");
        this.add((Component)this.refreshLabel, "South");
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                VideoArchiveEditorPanel.this.refresh();
            }
        });
    }

    @Override
    @EventSubscriber(eventClass=ObservationsAddedEvent.class)
    public void respondTo(ObservationsAddedEvent event) {
        this.needsRefresh();
    }

    @Override
    @EventSubscriber(eventClass=ObservationsChangedEvent.class)
    public void respondTo(ObservationsChangedEvent event) {
        this.needsRefresh();
    }

    @Override
    @EventSubscriber(eventClass=ObservationsRemovedEvent.class)
    public void respondTo(ObservationsRemovedEvent event) {
        this.needsRefresh();
    }

    @Override
    @EventSubscriber(eventClass=VideoArchiveChangedEvent.class)
    public void respondTo(VideoArchiveChangedEvent event) {
        this.refresh();
    }

    @Override
    @EventSubscriber(eventClass=VideoArchiveSelectedEvent.class)
    public void respondTo(VideoArchiveSelectedEvent event) {
        this.refresh();
    }

    @Override
    @EventSubscriber(eventClass=VideoFramesChangedEvent.class)
    public void respondTo(VideoFramesChangedEvent event) {
        this.needsRefresh();
    }

    private void refresh() {
        this.controller.refresh();
        this.getBtnRefresh().setIcon(this.noRefreshIcon);
        this.refreshLabel.setText("                                                                    ");
    }

    private void needsRefresh() {
        this.getBtnRefresh().setIcon(this.needsRefreshIcon);
        this.refreshLabel.setText("Press the refresh button (in red) to synchronize with latest edits!!");
    }

    @Override
    public void respondTo(ObservationsSelectedEvent event) {
    }
}

