/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.ppanel;

import java.awt.Component;
import java.awt.LayoutManager;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.mbari.awt.layout.VerticalFlowLayout;
import org.mbari.swing.PropertyPanel;
import org.mbari.util.IObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.annotation.Observation;
import vars.annotation.VideoFrame;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.eventbus.ObservationsSelectedEvent;
import vars.annotation.ui.eventbus.VideoFramesChangedEvent;
import vars.annotation.ui.ppanel.PPanel;

public abstract class PropertiesPanel
extends JPanel
implements IObserver {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    String missingValue = " ";
    Map<String, PropertyPanel> propertyMap = new HashMap<String, PropertyPanel>();

    public PropertiesPanel() {
        this.initialize();
        AnnotationProcessor.process((Object)this);
    }

    @EventSubscriber(eventClass=ObservationsSelectedEvent.class)
    public void respondTo(ObservationsSelectedEvent event) {
        Collection observations = (Collection)event.get();
        Observation obs = observations.size() == 1 ? (Observation)observations.iterator().next() : null;
        this.update(obs, "");
    }

    @EventSubscriber(eventClass=VideoFramesChangedEvent.class)
    public void respondTo(VideoFramesChangedEvent event) {
        Collection videoFrames = (Collection)event.get();
        List effectedObservations = videoFrames.stream().map(VideoFrame::getObservations).flatMap(Collection::stream).collect(Collectors.toList());
        Collection<Observation> observations = StateLookup.getSelectedObservations();
        effectedObservations.retainAll(observations);
        if (effectedObservations.size() == 1) {
            this.update(effectedObservations.get(0), null);
        }
    }

    void addToolTip(String name) {
        PropertyPanel p = this.getPropertyPanel(name);
        final JTextField f = p.getValueField();
        f.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateToolTip();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateToolTip();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateToolTip();
            }

            private void updateToolTip() {
                f.setToolTipText(f.getText());
            }
        });
    }

    void clearValues() {
        for (String key : this.propertyMap.keySet()) {
            PropertyPanel p = this.propertyMap.get(key);
            p.setProperty((Object)key, (Object)this.missingValue);
        }
    }

    PropertyPanel getPropertyPanel(String name) {
        PropertyPanel obj = this.propertyMap.get(name);
        PropertyPanel p = null;
        if (obj != null) {
            p = obj;
        }
        return p;
    }

    private void initialize() {
        this.setLayout((LayoutManager)new VerticalFlowLayout());
    }

    void setProperties(Object obj) {
        if (obj != null) {
            Class<?> objClass = obj.getClass();
            Class[] paramClass = new Class[]{};
            Object[] args = new Object[]{};
            Object value = this.missingValue;
            for (String key : this.propertyMap.keySet()) {
                String firstLetter = key.substring(0, 1).toUpperCase();
                String name = "get" + firstLetter + key.substring(1, key.length());
                try {
                    Method method = objClass.getMethod(name, paramClass);
                    value = method.invoke(obj, args);
                }
                catch (Exception e) {
                    if (this.log.isWarnEnabled()) {
                        this.log.warn("Problem setting properties", (Throwable)e);
                    }
                    value = this.missingValue;
                }
                PropertyPanel p = this.propertyMap.get(key);
                try {
                    p.setProperty((Object)key, value);
                }
                catch (Exception e) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Unable to set '" + key + "' property to '" + value + " on the tabbed panel");
                    }
                    p.setProperty((Object)key, (Object)this.missingValue);
                }
            }
        } else {
            this.clearValues();
        }
    }

    void setPropertyNames(String[] names) {
        for (int i = 0; i < names.length; ++i) {
            PPanel p = new PPanel(names[i], this.missingValue);
            p.setAlignmentX(0.0f);
            p.setAlignmentY(0.0f);
            this.propertyMap.put(names[i], p);
            this.add((Component)((Object)p));
        }
    }

    public abstract void update(Object var1, Object var2);

    protected Double readDouble(String fieldName, Double defaultValue) {
        try {
            return Double.parseDouble(this.getPropertyPanel(fieldName).getValueField().getText());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    protected Float readFloat(String fieldName, Float defaultValue) {
        try {
            return Float.valueOf(Float.parseFloat(this.getPropertyPanel(fieldName).getValueField().getText()));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    protected String readString(String fieldName, String defaultValue) {
        try {
            return this.getPropertyPanel(fieldName).getValueField().getText();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    protected Integer readInteger(String fieldName, Integer defaultValue) {
        try {
            return Integer.parseInt(this.getPropertyPanel(fieldName).getValueField().getText());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }
}

