/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.ppanel;

import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.bushe.swing.event.EventBus;
import org.mbari.awt.event.ActionAdapter;
import org.mbari.awt.event.NonDigitConsumingKeyListener;
import org.mbari.swing.PropertyPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.annotation.CameraDeployment;
import vars.annotation.Observation;
import vars.annotation.VideoArchive;
import vars.annotation.VideoArchiveSet;
import vars.annotation.VideoFrame;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.commandqueue.CommandEvent;
import vars.annotation.ui.commandqueue.impl.ChangeSequenceNumberCmd;
import vars.annotation.ui.commandqueue.impl.ChangeVideoArchiveSetCmd;
import vars.annotation.ui.commandqueue.impl.RenameVideoArchiveCmd;
import vars.annotation.ui.dialogs.RenameVideoArchiveDialog;
import vars.annotation.ui.ppanel.PropertiesPanel;

public class PVideoArchivePanel
extends PropertiesPanel {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ActionAdapter changeNameAction;
    private RenameVideoArchiveDialog changeNameDialog;
    private final ToolBelt toolBelt;

    public PVideoArchivePanel(ToolBelt toolBelt) {
        this.toolBelt = toolBelt;
        this.setPropertyNames(new String[]{"recordedDate", "videoArchiveName", "shipName", "platformName", "formatCode", "startDate", "endDate", "chiefScientist", "diveNumber", "trackingNumber"});
        this.addListeners();
    }

    private void addListeners() {
        PropertyPanel p = this.getPropertyPanel("videoArchiveName");
        p.setEditAction(this.getChangeNameAction());
        p = this.getPropertyPanel("shipName");
        JTextField f2 = p.getValueField();
        f2.addActionListener(e -> {
            VideoArchive va;
            Observation obs;
            VideoFrame vf;
            Collection<Observation> observations = StateLookup.getSelectedObservations();
            if ((observations = new ArrayList<Observation>(observations)).size() == 1 && (vf = (obs = observations.iterator().next()).getVideoFrame()) != null && (va = vf.getVideoArchive()) != null) {
                VideoArchiveSet vas = va.getVideoArchiveSet();
                ChangeVideoArchiveSetCmd command = new ChangeVideoArchiveSetCmd(f2.getText(), vas.getPlatformName(), vas.getFormatCode(), vas);
                CommandEvent commandEvent = new CommandEvent(command);
                EventBus.publish((Object)commandEvent);
            }
        });
        p.setEditable(true);
        p = this.getPropertyPanel("platformName");
        JTextField f3 = p.getValueField();
        f3.addActionListener(e -> {
            VideoArchive va;
            Observation obs;
            VideoFrame vf;
            Collection<Observation> observations = StateLookup.getSelectedObservations();
            if ((observations = new ArrayList<Observation>(observations)).size() == 1 && (vf = (obs = observations.iterator().next()).getVideoFrame()) != null && (va = vf.getVideoArchive()) != null) {
                VideoArchiveSet vas = va.getVideoArchiveSet();
                ChangeVideoArchiveSetCmd command = new ChangeVideoArchiveSetCmd(vas.getShipName(), f3.getText(), vas.getFormatCode(), vas);
                CommandEvent commandEvent = new CommandEvent(command);
                EventBus.publish((Object)commandEvent);
            }
        });
        p.setEditable(true);
        p = this.getPropertyPanel("diveNumber");
        JTextField f4 = p.getValueField();
        f4.addKeyListener((KeyListener)new NonDigitConsumingKeyListener());
        f4.addActionListener(e -> {
            VideoArchive va;
            Observation obs;
            VideoFrame vf;
            Collection<Observation> observations = StateLookup.getSelectedObservations();
            if ((observations = new ArrayList<Observation>(observations)).size() == 1 && (vf = (obs = observations.iterator().next()).getVideoFrame()) != null && (va = vf.getVideoArchive()) != null) {
                try {
                    CameraDeployment cameraDeployment = (CameraDeployment)va.getVideoArchiveSet().getCameraDeployments().iterator().next();
                    int newSeqNumber = Integer.parseInt(f4.getText());
                    int oldSeqNumber = cameraDeployment.getSequenceNumber();
                    long id = (Long)va.getPrimaryKey();
                    ChangeSequenceNumberCmd command = new ChangeSequenceNumberCmd(newSeqNumber, oldSeqNumber, id);
                    CommandEvent commandEvent = new CommandEvent(command);
                    EventBus.publish((Object)commandEvent);
                }
                catch (Exception e1) {
                    this.log.info("Failed to set diveNumber", (Throwable)e1);
                }
            }
        });
        p.setEditable(true);
    }

    private ActionAdapter getChangeNameAction() {
        if (this.changeNameAction == null) {
            this.changeNameAction = new ActionAdapter(){

                public void doAction() {
                    PVideoArchivePanel.this.getChangeNameDialog().setVisible(true);
                }
            };
        }
        return this.changeNameAction;
    }

    private RenameVideoArchiveDialog getChangeNameDialog() {
        if (this.changeNameDialog == null) {
            this.changeNameDialog = new RenameVideoArchiveDialog(SwingUtilities.getWindowAncestor(this), this.toolBelt);
            this.changeNameDialog.getOkayButton().addActionListener(e -> {
                VideoArchive videoArchive = StateLookup.getVideoArchive();
                if (videoArchive != null) {
                    RenameVideoArchiveCmd command = new RenameVideoArchiveCmd(videoArchive.getName(), this.getChangeNameDialog().getNewVideoArchiveName());
                    CommandEvent commandEvent = new CommandEvent(command);
                    EventBus.publish((Object)commandEvent);
                }
            });
        }
        return this.changeNameDialog;
    }

    @Override
    public void update(Object obj, Object changeCode) {
        Observation obs = (Observation)obj;
        if (obs == null) {
            this.clearValues();
            return;
        }
        VideoFrame vf = obs.getVideoFrame();
        if (vf == null) {
            this.clearValues();
        } else {
            PVideoArchive pvf = new PVideoArchive(vf);
            this.setProperties(pvf);
        }
    }

    private class PVideoArchive {
        private String chiefScientist;
        private String diveNumber;
        private Date endDate;
        private String formatCode;
        private String platformName;
        private Date recordedDate;
        private String shipName;
        private Date startDate;
        private String trackingNumber;
        private String videoArchiveName;

        PVideoArchive(VideoFrame videoFrame) {
            this.recordedDate = videoFrame.getRecordedDate();
            VideoArchive va = videoFrame.getVideoArchive();
            if (va != null) {
                this.videoArchiveName = va.getName();
                VideoArchiveSet vas = va.getVideoArchiveSet();
                if (vas != null) {
                    this.formatCode = vas.getFormatCode() + "";
                    this.shipName = vas.getShipName();
                    this.platformName = vas.getPlatformName();
                    this.startDate = vas.getStartDate();
                    this.endDate = vas.getEndDate();
                    this.trackingNumber = vas.getTrackingNumber();
                    ArrayList cpd = new ArrayList(vas.getCameraDeployments());
                    if (cpd.size() > 0) {
                        String sep = "";
                        if (cpd.size() > 1) {
                            sep = " | ";
                        }
                        StringBuilder d = new StringBuilder();
                        StringBuilder s = new StringBuilder();
                        for (CameraDeployment pd : cpd) {
                            d.append(pd.getSequenceNumber()).append(sep);
                            s.append(pd.getChiefScientistName()).append(sep);
                        }
                        this.chiefScientist = s.toString();
                        this.diveNumber = d.toString();
                    }
                }
            }
        }

        public String getChiefScientist() {
            return this.chiefScientist;
        }

        public String getDiveNumber() {
            return this.diveNumber;
        }

        public Date getEndDate() {
            return this.endDate;
        }

        public String getFormatCode() {
            return this.formatCode;
        }

        public String getPlatformName() {
            return this.platformName;
        }

        public Date getRecordedDate() {
            return this.recordedDate;
        }

        public String getShipName() {
            return this.shipName;
        }

        public Date getStartDate() {
            return this.startDate;
        }

        public String getTrackingNumber() {
            return this.trackingNumber;
        }

        public String getVideoArchiveName() {
            return this.videoArchiveName;
        }
    }
}

