/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.ppanel;

import java.awt.Color;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.bushe.swing.event.EventBus;
import org.mbari.awt.event.ActionAdapter;
import org.mbari.swing.PropertyPanel;
import org.mbari.util.IObserver;
import vars.CacheClearedEvent;
import vars.CacheClearedListener;
import vars.annotation.ImmutablePhysicalData;
import vars.annotation.Observation;
import vars.annotation.PhysicalData;
import vars.annotation.PhysicalDataValueEq;
import vars.annotation.VideoFrame;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.commandqueue.CommandEvent;
import vars.annotation.ui.commandqueue.impl.ChangePhysicalDataCmd;
import vars.annotation.ui.ppanel.PropertiesPanel;

public class PPhysicalDataPanel
extends PropertiesPanel
implements IObserver {
    private static final String[] propertyNames = new String[]{"Latitude", "Longitude", "Depth", "Altitude", "Temperature", "Salinity", "Oxygen", "Light"};
    private volatile PhysicalData physicalData;
    private final PhysicalDataValueEq eq = new PhysicalDataValueEq();
    private final ActionAdapter updateAction = new ActionAdapter(){

        public void doAction() {
            PhysicalData newPhysicalData;
            if (PPhysicalDataPanel.this.physicalData != null && (newPhysicalData = PPhysicalDataPanel.this.readDataPanels()) != null) {
                ChangePhysicalDataCmd command = new ChangePhysicalDataCmd(PPhysicalDataPanel.this.physicalData, newPhysicalData);
                CommandEvent commandEvent = new CommandEvent(command);
                EventBus.publish((Object)commandEvent);
            }
        }
    };

    public PPhysicalDataPanel(ToolBelt toolBelt) {
        this.setPropertyNames(propertyNames);
        for (String name : propertyNames) {
            PropertyPanel panel = this.getPropertyPanel(name);
            JTextField valueField = panel.getValueField();
            valueField.addActionListener(e -> this.updateAction.doAction());
            valueField.getDocument().addDocumentListener(new MyDocListener(valueField));
            panel.setEditable(true);
        }
        toolBelt.getPersistenceCache().addCacheClearedListener(new CacheClearedListener(){

            public void afterClear(CacheClearedEvent evt) {
                PPhysicalDataPanel.this.update(null, null);
            }

            public void beforeClear(CacheClearedEvent evt) {
            }
        });
    }

    private boolean isEdited() {
        PhysicalData a = this.physicalData;
        PhysicalData b = this.readDataPanels();
        if (a == null || b == null) {
            return false;
        }
        return !this.eq.equal(a, b);
    }

    @Override
    public void update(Object obj, Object changeCode) {
        Observation obs = (Observation)obj;
        if (obs == null) {
            this.clearValues();
            return;
        }
        VideoFrame vf = obs.getVideoFrame();
        if (vf == null) {
            this.clearValues();
        } else {
            this.physicalData = vf.getPhysicalData();
            if (this.physicalData == null) {
                this.clearValues();
            } else {
                this.setProperties(this.physicalData);
            }
            for (String name : propertyNames) {
                this.getPropertyPanel(name).getValueField().setForeground(Color.BLACK);
            }
        }
    }

    private PhysicalData readDataPanels() {
        if (this.physicalData == null) {
            return null;
        }
        return new ImmutablePhysicalData(this.physicalData.getPrimaryKey(), this.readFloat("Altitude", this.physicalData.getAltitude()), this.readFloat("Depth", this.physicalData.getDepth()), this.readDouble("Latitude", this.physicalData.getLatitude()), this.readFloat("Light", this.physicalData.getLight()), this.physicalData.getLogDate(), this.readDouble("Longitude", this.physicalData.getLongitude()), this.readFloat("Oxygen", this.physicalData.getOxygen()), this.readFloat("Salinity", this.physicalData.getSalinity()), this.readFloat("Temperature", this.physicalData.getTemperature()));
    }

    class MyDocListener
    implements DocumentListener {
        private final JTextField textField;
        public final Color defaultColor;

        public MyDocListener(JTextField textField) {
            this.textField = textField;
            this.defaultColor = textField.getForeground();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateUI();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateUI();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateUI();
        }

        private void updateUI() {
            Color color = PPhysicalDataPanel.this.isEdited() ? Color.RED : this.defaultColor;
            this.textField.setForeground(color);
        }
    }
}

