/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.ppanel;

import java.util.Date;
import org.mbari.awt.event.ActionAdapter;
import org.mbari.swing.PropertyPanel;
import vars.CacheClearedEvent;
import vars.CacheClearedListener;
import vars.annotation.AnnotationFactory;
import vars.annotation.Observation;
import vars.annotation.VideoFrame;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.actions.ChangeTimeCodeActionWithDialog;
import vars.annotation.ui.ppanel.PropertiesPanel;

public class PObservationPanel
extends PropertiesPanel {
    private final Annotation annotation;
    private ActionAdapter timeCodeAction;
    private final ToolBelt toolBelt;

    public PObservationPanel(ToolBelt toolBelt) {
        this.toolBelt = toolBelt;
        this.annotation = new Annotation();
        this.setPropertyNames(new String[]{"TimeCode", "Concept", "RecordedDate", "ObservationDate", "Observer", "X", "Y"});
        this.addListeners();
        this.addToolTip("Concept");
        toolBelt.getPersistenceCache().addCacheClearedListener(new CacheClearedListener(){

            public void afterClear(CacheClearedEvent evt) {
                PObservationPanel.this.update(PObservationPanel.this.annotation.getObservation(), null);
            }

            public void beforeClear(CacheClearedEvent evt) {
            }
        });
    }

    private void addListeners() {
        PropertyPanel p = this.getPropertyPanel("TimeCode");
        p.getEditButton();
        p.setEditAction(this.getTimeCodeAction());
    }

    private ActionAdapter getTimeCodeAction() {
        if (this.timeCodeAction == null) {
            this.timeCodeAction = new ChangeTimeCodeActionWithDialog(this.toolBelt){

                @Override
                public void doAction() {
                    super.doAction();
                    PObservationPanel.this.update(PObservationPanel.this.annotation.getObservation(), "");
                }
            };
        }
        return this.timeCodeAction;
    }

    @Override
    public void update(Object obj, Object changeCode) {
        Observation obs = (Observation)obj;
        if (obs == null) {
            this.clearValues();
            return;
        }
        this.annotation.setObservation(obs);
        this.setProperties(this.annotation);
    }

    private class Annotation {
        private final Observation nullObs;
        private Observation observation;

        Annotation() {
            AnnotationFactory factory = PObservationPanel.this.toolBelt.getAnnotationFactory();
            VideoFrame nullVf = factory.newVideoFrame();
            this.nullObs = factory.newObservation();
            nullVf.addObservation(this.nullObs);
            this.setObservation(this.nullObs);
        }

        public String getConcept() {
            return this.observation.getConceptName();
        }

        Observation getObservation() {
            return this.observation;
        }

        public Date getObservationDate() {
            return this.observation.getObservationDate();
        }

        public String getObserver() {
            return this.observation.getObserver();
        }

        public Date getRecordedDate() {
            return this.observation.getVideoFrame().getRecordedDate();
        }

        public String getTimeCode() {
            return this.observation.getVideoFrame().getTimecode();
        }

        void setObservation(Observation obs) {
            this.observation = obs == null ? this.nullObs : obs;
        }

        public double getX() {
            return this.observation.getX() == null ? Double.NaN : this.observation.getX();
        }

        public double getY() {
            return this.observation.getY() == null ? Double.NaN : this.observation.getY();
        }
    }
}

