/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.ppanel;

import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.bushe.swing.event.EventBus;
import org.mbari.awt.event.ActionAdapter;
import org.mbari.swing.PropertyPanel;
import vars.DAO;
import vars.annotation.CameraData;
import vars.annotation.CameraDataValueEq;
import vars.annotation.CameraDirections;
import vars.annotation.ImmutableCameraData;
import vars.annotation.Observation;
import vars.annotation.VideoFrame;
import vars.annotation.ui.AnnotationFrame;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.commandqueue.CommandEvent;
import vars.annotation.ui.commandqueue.impl.ChangeCameraDataCmd;
import vars.annotation.ui.commandqueue.impl.ChangeCameraDirectionsCmd;
import vars.annotation.ui.ppanel.PropertiesPanel;

public class PCameraDataPanel
extends PropertiesPanel {
    private ActionAdapter directionAction;
    private final ToolBelt toolBelt;
    private volatile CameraData cameraData;
    private CameraDataValueEq eq = new CameraDataValueEq();
    private static final String[] propertyNames = new String[]{"Direction", "Name", "Zoom", "Focus", "Iris", "FieldWidth", "ImageReference", "X", "Y"};
    private final ActionAdapter updateAction = new ActionAdapter(){

        public void doAction() {
            CameraData newCameraData;
            if (PCameraDataPanel.this.cameraData != null && (newCameraData = PCameraDataPanel.this.readDataPanels()) != null) {
                ChangeCameraDataCmd command = new ChangeCameraDataCmd(PCameraDataPanel.this.cameraData, newCameraData);
                CommandEvent commandEvent = new CommandEvent(command);
                EventBus.publish((Object)commandEvent);
            }
        }
    };

    public PCameraDataPanel(ToolBelt toolBelt) {
        this.toolBelt = toolBelt;
        this.setPropertyNames(propertyNames);
        Arrays.stream(propertyNames).filter(name -> !name.equals("Direction")).forEach(name -> {
            PropertyPanel panel = this.getPropertyPanel((String)name);
            JTextField valueField = panel.getValueField();
            valueField.addActionListener(e -> this.updateAction.doAction());
            valueField.getDocument().addDocumentListener(new MyDocListener(valueField));
            panel.setEditable(true);
        });
        this.addListeners();
        this.addToolTip("ImageReference");
    }

    private void addListeners() {
        PropertyPanel p = this.getPropertyPanel("Direction");
        p.getEditButton();
        p.setEditAction(this.getDirectionAction());
    }

    private boolean isEdited() {
        CameraData a = this.cameraData;
        CameraData b = this.readDataPanels();
        if (a == null || b == null) {
            return false;
        }
        return !this.eq.equal(a, b);
    }

    private ActionAdapter getDirectionAction() {
        if (this.directionAction == null) {
            this.directionAction = new ActionAdapter(){

                public void doAction() {
                    Collection<Observation> observations;
                    PropertyPanel p = PCameraDataPanel.this.getPropertyPanel("Direction");
                    JTextField f1 = p.getValueField();
                    String initialValue = f1.getText();
                    AnnotationFrame frame = StateLookup.getAnnotationFrame();
                    CameraDirections selectedValue = (CameraDirections)JOptionPane.showInputDialog(frame, "Select a camera direction.", "VARS - Camera Direction", 3, null, CameraDirections.values(), CameraDirections.findValue((String)initialValue));
                    if (selectedValue != null && (observations = StateLookup.getSelectedObservations()).size() == 1) {
                        try {
                            DAO dao = PCameraDataPanel.this.toolBelt.getAnnotationDAOFactory().newDAO();
                            dao.startTransaction();
                            Observation obs = observations.iterator().next();
                            obs = (Observation)dao.find((Object)obs);
                            VideoFrame vf = obs.getVideoFrame();
                            dao.endTransaction();
                            dao.close();
                            ChangeCameraDirectionsCmd command = new ChangeCameraDirectionsCmd(selectedValue.getDirection(), (Collection<VideoFrame>)ImmutableList.of((Object)vf));
                            CommandEvent commandEvent = new CommandEvent(command);
                            EventBus.publish((Object)commandEvent);
                        }
                        catch (Exception e1) {
                            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e1);
                        }
                        f1.setText(selectedValue.toString());
                    }
                }
            };
        }
        return this.directionAction;
    }

    @Override
    public void update(Object obj, Object changeCode) {
        Observation obs = (Observation)obj;
        if (obs == null) {
            this.clearValues();
            return;
        }
        VideoFrame vf = obs.getVideoFrame();
        if (vf == null) {
            this.clearValues();
        } else {
            this.cameraData = vf.getCameraData();
            if (this.cameraData == null) {
                this.clearValues();
            } else {
                this.setProperties(this.cameraData);
            }
            for (String name : propertyNames) {
                this.getPropertyPanel(name).getValueField().setForeground(Color.BLACK);
            }
        }
    }

    private CameraData readDataPanels() {
        if (this.cameraData == null) {
            return null;
        }
        return new ImmutableCameraData(this.cameraData.getPrimaryKey(), this.readString("Direction", this.cameraData.getDirection()), this.readDouble("FieldWidth", this.cameraData.getFieldWidth()), this.readInteger("Focus", this.cameraData.getFocus()), this.cameraData.getHeading(), this.readString("ImageReference", this.cameraData.getImageReference()), this.readInteger("Iris", this.cameraData.getIris()), this.cameraData.getLogDate(), this.readString("Name", this.cameraData.getName()), this.cameraData.getPitch(), this.cameraData.getRoll(), this.cameraData.getViewHeight(), this.cameraData.getViewWidth(), this.cameraData.getViewUnits(), this.readFloat("X", this.cameraData.getX()), this.cameraData.getXYUnits(), this.readFloat("Y", this.cameraData.getY()), this.cameraData.getZ(), this.cameraData.getZUnits(), this.readInteger("Zoom", this.cameraData.getZoom()));
    }

    class MyDocListener
    implements DocumentListener {
        private final JTextField textField;
        public final Color defaultColor;

        public MyDocListener(JTextField textField) {
            this.textField = textField;
            this.defaultColor = textField.getForeground();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateUI();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateUI();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateUI();
        }

        private void updateUI() {
            Color color = PCameraDataPanel.this.isEdited() ? Color.RED : this.defaultColor;
            this.textField.setForeground(color);
        }
    }
}

