/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.ppanel;

import com.google.common.collect.Collections2;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.mbari.swing.JImageUrlCanvas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.annotation.Observation;
import vars.annotation.VideoFrame;
import vars.annotation.ui.AnnotationImageCanvas;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.eventbus.ObservationsSelectedEvent;
import vars.annotation.ui.imagepanel.ImageAnnotationFrame;

public class FrameGrabPanel
extends JPanel {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private JImageUrlCanvas imageCanvas;
    private final ImageAnnotationFrame imageFrame;

    public FrameGrabPanel(ToolBelt toolBelt) {
        this.imageFrame = new ImageAnnotationFrame(toolBelt);
        this.imageFrame.setDefaultCloseOperation(1);
        this.imageFrame.pack();
        this.initialize();
        AnnotationProcessor.process((Object)this);
    }

    JImageUrlCanvas getImageCanvas() {
        if (this.imageCanvas == null) {
            this.imageCanvas = new AnnotationImageCanvas(this.getClass().getResource("/images/vars/annotation/no_image.jpg"));
            this.imageCanvas.setSize(this.getSize());
        }
        return this.imageCanvas;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder("image"));
        this.setMinimumSize(new Dimension(60, 50));
        this.setPreferredSize(new Dimension(60, 50));
        this.add((Component)this.getImageCanvas(), "Center");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                FrameGrabPanel.this.resizeHandler(evt);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() < 2) {
                    return;
                }
                FrameGrabPanel.this.imageFrame.setVisible(true);
            }
        });
    }

    private void resizeHandler(ComponentEvent evt) {
        this.imageCanvas.setSize(this.getSize());
    }

    @EventSubscriber(eventClass=ObservationsSelectedEvent.class)
    public void respondTo(ObservationsSelectedEvent event) {
        this.updateObservations((Collection)event.get());
    }

    public void updateObservations(Collection<Observation> observations) {
        HashSet videoFrames;
        URL imageReference = null;
        if (observations != null && (videoFrames = new HashSet(Collections2.transform(observations, from -> from.getVideoFrame()))).size() == 1) {
            VideoFrame videoFrame = (VideoFrame)videoFrames.iterator().next();
            try {
                imageReference = new URL(videoFrame.getCameraData().getImageReference());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.getImageCanvas().setUrl(imageReference);
    }
}

