/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.imagepanel;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import vars.annotation.AnnotationDAOFactory;
import vars.annotation.Observation;
import vars.annotation.ObservationDAO;
import vars.annotation.VideoFrame;
import vars.annotation.VideoFrameDAO;
import vars.annotation.ui.PersistenceController;
import vars.annotation.ui.StateLookup;
import vars.annotation.ui.eventbus.ObservationsAddedEvent;
import vars.annotation.ui.eventbus.ObservationsChangedEvent;
import vars.annotation.ui.eventbus.ObservationsRemovedEvent;
import vars.annotation.ui.eventbus.ObservationsSelectedEvent;
import vars.annotation.ui.eventbus.UIEvent;
import vars.annotation.ui.eventbus.UIEventSubscriber;
import vars.annotation.ui.eventbus.VideoArchiveChangedEvent;
import vars.annotation.ui.eventbus.VideoArchiveSelectedEvent;
import vars.annotation.ui.eventbus.VideoFramesChangedEvent;
import vars.annotation.ui.imagepanel.IAFRepaintEvent;

public class UIDataCoordinator
implements UIEventSubscriber {
    private Collection<Observation> emptySet = Collections.unmodifiableSet(new HashSet());
    private Collection<Observation> selectedObservations = Collections.synchronizedSet(new HashSet());
    private final AnnotationDAOFactory annotationDAOFactory;
    private volatile VideoFrame videoFrame;

    public UIDataCoordinator(AnnotationDAOFactory annotationDAOFactory) {
        this.annotationDAOFactory = annotationDAOFactory;
        AnnotationProcessor.process((Object)this);
    }

    public Collection<Observation> getObservations() {
        return this.videoFrame == null ? this.emptySet : this.videoFrame.getObservations();
    }

    public Collection<Observation> getSelectedObservations() {
        return this.selectedObservations;
    }

    public VideoFrame getVideoFrame() {
        return this.videoFrame;
    }

    @Override
    @EventSubscriber(eventClass=ObservationsAddedEvent.class)
    public void respondTo(ObservationsAddedEvent event) {
        this.respondToObservationEvent(event);
    }

    @Override
    @EventSubscriber(eventClass=ObservationsChangedEvent.class)
    public void respondTo(ObservationsChangedEvent event) {
        this.respondToObservationEvent(event);
    }

    @Override
    @EventSubscriber(eventClass=ObservationsRemovedEvent.class)
    public void respondTo(ObservationsRemovedEvent event) {
        this.respondToObservationEvent(event);
    }

    @Override
    @EventSubscriber(eventClass=ObservationsSelectedEvent.class)
    public void respondTo(ObservationsSelectedEvent event) {
        Set<VideoFrame> selectedVideoFrames = PersistenceController.toVideoFrames((Collection)event.get());
        if (selectedVideoFrames.size() == 1) {
            VideoFrame newVideoFrame = (VideoFrame)selectedVideoFrames.iterator().next();
            this.setVideoFrame(newVideoFrame, (Collection)event.get());
        } else {
            this.setVideoFrame(null, this.emptySet);
        }
    }

    @Override
    @EventSubscriber(eventClass=VideoArchiveChangedEvent.class)
    public void respondTo(VideoArchiveChangedEvent event) {
        this.setVideoFrame(null, this.emptySet);
    }

    @Override
    @EventSubscriber(eventClass=VideoArchiveSelectedEvent.class)
    public void respondTo(VideoArchiveSelectedEvent event) {
        this.setVideoFrame(null, this.emptySet);
    }

    @Override
    @EventSubscriber(eventClass=VideoFramesChangedEvent.class)
    public void respondTo(VideoFramesChangedEvent event) {
        Collection changedVideoFrame = Collections2.filter((Collection)((Collection)event.get()), (Predicate)new Predicate<VideoFrame>(){

            public boolean apply(VideoFrame input) {
                return input.equals(UIDataCoordinator.this.videoFrame);
            }
        });
        if (!changedVideoFrame.isEmpty()) {
            Collection<Observation> obs = StateLookup.getSelectedObservations();
            this.setVideoFrame((VideoFrame)changedVideoFrame.iterator().next(), new ArrayList<Observation>(obs));
        }
    }

    private void respondToObservationEvent(UIEvent<Collection<Observation>> event) {
        Collection<Observation> alteredObservations = event.get();
        Set<VideoFrame> videoFrames = PersistenceController.toVideoFrames(alteredObservations);
        if (this.videoFrame != null && videoFrames.contains(this.videoFrame)) {
            this.setVideoFrame(this.videoFrame, new ArrayList<Observation>(this.selectedObservations));
        }
    }

    public void setVideoFrame(VideoFrame _videoFrame, Collection<Observation> _selectedObservations) {
        this.selectedObservations.clear();
        if (_videoFrame == null) {
            this.videoFrame = null;
            EventBus.publish((Object)new IAFRepaintEvent((Object)this, this));
        } else {
            VideoFrameDAO dao = this.annotationDAOFactory.newVideoFrameDAO();
            ObservationDAO obsDao = this.annotationDAOFactory.newObservationDAO(dao.getEntityManager());
            dao.startTransaction();
            this.videoFrame = (VideoFrame)dao.find((Object)_videoFrame);
            for (Observation obs : _selectedObservations) {
                Observation foundObs = (Observation)obsDao.find((Object)obs);
                if (foundObs == null) continue;
                this.selectedObservations.add(foundObs);
            }
            dao.endTransaction();
            dao.close();
            EventBus.publish((Object)new IAFRepaintEvent((Object)this, this));
        }
    }
}

