/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.imagepanel;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.jdesktop.jxlayer.JXLayer;
import org.mbari.awt.AwtUtilities;
import org.mbari.swing.JImageUrlCanvas;
import vars.annotation.ui.imagepanel.JXCrossHairPainter;
import vars.annotation.ui.imagepanel.MultiLayerUI;

public class PointAdditionLayerUI<T extends JImageUrlCanvas>
extends MultiLayerUI<T> {
    private Point coordinatePoint = null;
    private String coordinateString = null;
    final Collection<Point> sourcePoints = new Vector<Point>();
    private final Font font = new Font("Sans Serif", 0, 12);
    private JXCrossHairPainter<T> crossHairPainter = new JXCrossHairPainter();

    @Override
    public void clearPainters() {
        super.clearPainters();
        this.addPainter(this.crossHairPainter);
    }

    @Override
    protected void paintLayer(Graphics2D g2, JXLayer<? extends T> jxl) {
        super.paintLayer(g2, jxl);
        if (this.coordinateString != null) {
            g2.setXORMode(Color.WHITE);
            g2.setFont(this.font);
            g2.drawString(this.coordinateString, this.coordinatePoint.x, this.coordinatePoint.y);
        }
        g2.setPaintMode();
        g2.setPaint(new Color(255, 0, 0, 180));
        g2.setStroke(new BasicStroke(3.0f));
        JImageUrlCanvas imageCanvas = (JImageUrlCanvas)jxl.getView();
        for (Point point : this.sourcePoints) {
            point = AwtUtilities.toPoint((Point2D)imageCanvas.convertToComponent((Point2D)point));
            int x = point.x;
            int y = point.y;
            int armLength = 7;
            GeneralPath gp = new GeneralPath();
            gp.moveTo(x - armLength, y - armLength);
            gp.lineTo(x + armLength, y + armLength);
            gp.moveTo(x + armLength, y - armLength);
            gp.lineTo(x - armLength, y + armLength);
            g2.draw(gp);
        }
        g2.setPaintMode();
    }

    @Override
    protected void processMouseEvent(MouseEvent me, JXLayer<? extends T> jxl) {
        super.processMouseEvent(me, jxl);
        if (me.getID() == 502) {
            Point point = SwingUtilities.convertPoint(me.getComponent(), me.getPoint(), jxl);
            JImageUrlCanvas imageCanvas = (JImageUrlCanvas)jxl.getView();
            Point imagePoint = AwtUtilities.toPoint((Point2D)imageCanvas.convertToImage((Point2D)point));
            this.sourcePoints.add(imagePoint);
            this.setDirty(true);
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent me, JXLayer<? extends T> jxl) {
        super.processMouseMotionEvent(me, jxl);
        if (me.getID() == 503 || me.getID() == 506) {
            Point point = SwingUtilities.convertPoint(me.getComponent(), me.getPoint(), jxl);
            JImageUrlCanvas imageCanvas = (JImageUrlCanvas)jxl.getView();
            if (imageCanvas.getImageRectangle().contains(point)) {
                Point imagePoint = AwtUtilities.toPoint((Point2D)imageCanvas.convertToImage((Point2D)point));
                Point componentPoint = AwtUtilities.toPoint((Point2D)imageCanvas.convertToComponent((Point2D)imagePoint));
                this.coordinateString = "(SRC[" + point.x + ", " + point.y + "] Image[" + imagePoint.x + ", " + imagePoint.y + "] DST[" + componentPoint.x + ", " + componentPoint.y + "])";
                this.coordinatePoint = point;
            } else {
                this.coordinateString = null;
                this.coordinatePoint = null;
            }
            this.setDirty(true);
        }
    }
}

