/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.imagepanel;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.JComponent;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.AbstractLayerUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.annotation.ui.imagepanel.JXPainter;

public class MultiLayerUI<T extends JComponent>
extends AbstractLayerUI<T> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Queue<JXPainter<T>> painters = new LinkedBlockingQueue<JXPainter<T>>();
    private final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equalsIgnoreCase("dirty")) {
                MultiLayerUI.this.setDirty(true);
            }
        }
    };

    public void addPainter(JXPainter<T> painter) {
        this.painters.add(painter);
        painter.getPropertyChangeSupport().addPropertyChangeListener(this.propertyChangeListener);
        this.setDirty(true);
    }

    public void clearPainters() {
        for (JXPainter jXPainter : this.painters) {
            jXPainter.getPropertyChangeSupport().removePropertyChangeListener(this.propertyChangeListener);
        }
        this.painters.clear();
        this.setDirty(true);
    }

    protected void paintLayer(Graphics2D g2, JXLayer<? extends T> jxl) {
        super.paintLayer(g2, jxl);
        for (JXPainter jXPainter : this.painters) {
            jXPainter.paintLayer(g2, jxl);
        }
    }

    protected void processMouseEvent(MouseEvent me, JXLayer<? extends T> jxl) {
        super.processMouseEvent(me, jxl);
        boolean dirty = false;
        for (JXPainter jXPainter : this.painters) {
            jXPainter.processMouseEvent(me, jxl);
            if (!jXPainter.isDirty()) continue;
            dirty = true;
        }
        if (dirty) {
            this.setDirty(dirty);
        }
    }

    protected void processMouseMotionEvent(MouseEvent me, JXLayer<? extends T> jxl) {
        super.processMouseMotionEvent(me, jxl);
        boolean dirty = false;
        for (JXPainter jXPainter : this.painters) {
            jXPainter.processMouseMotionEvent(me, jxl);
            if (!jXPainter.isDirty()) continue;
            dirty = true;
        }
        if (dirty) {
            this.setDirty(dirty);
        }
    }

    public void removePainter(JXPainter<T> painter) {
        this.painters.remove(painter);
        painter.getPropertyChangeSupport().removePropertyChangeListener(this.propertyChangeListener);
        this.setDirty(true);
    }
}

