/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.imagepanel;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jdesktop.jxlayer.JXLayer;
import org.mbari.awt.AwtUtilities;
import org.mbari.swing.JImageUrlCanvas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.ILink;
import vars.annotation.Association;
import vars.annotation.Observation;
import vars.annotation.ui.ToolBelt;
import vars.annotation.ui.imagepanel.CommonPainters;
import vars.annotation.ui.imagepanel.IAFRepaintEvent;
import vars.annotation.ui.imagepanel.ImageFrameLayerUI;
import vars.annotation.ui.imagepanel.JXPainter;
import vars.annotation.ui.imagepanel.JXSelectedObservationsPainter;
import vars.annotation.ui.imagepanel.MarkerStyle;
import vars.annotation.ui.imagepanel.Measurement;
import vars.annotation.ui.imagepanel.MeasurementCompletedEvent;
import vars.annotation.ui.imagepanel.MeasurementCompletedListener;
import vars.annotation.ui.imagepanel.MeasurementLayerSettingsBuilder;
import vars.annotation.ui.imagepanel.UIDataCoordinator;

public class MeasurementLayerUI<T extends JImageUrlCanvas>
extends ImageFrameLayerUI<T> {
    public static final String PROP_OBSERVATION = "Observation";
    private static final int markerDiameter = 10;
    private final JXPainter<T> selectedObservationPainter = new JXSelectedObservationsPainter(MarkerStyle.SELECTED_FAINT);
    private final Runnable resetRunable = new Runnable(){

        @Override
        public void run() {
            MeasurementLayerUI.this.lineStart.setLocation(0.0, 0.0);
            MeasurementLayerUI.this.lineEnd.setLocation(0.0, 0.0);
            MeasurementLayerUI.this.line.reset();
            MeasurementLayerUI.this.selectedLineEnd = false;
            MeasurementLayerUI.this.selectedLineStart = false;
            MeasurementLayerUI.this.setDirty(true);
        }
    };
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport((Object)this);
    private final Collection<MeasurementPath> measurementPaths = new Vector<MeasurementPath>();
    private final Collection<MeasurementCompletedListener> measurementCompletedListeners = new Vector<MeasurementCompletedListener>();
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Point2D lineStart = new Point2D.Double();
    private Font lineFont = new Font("Sans Serif", 0, 10);
    private final Point2D lineEnd = new Point2D.Double();
    private GeneralPath line = new GeneralPath();
    private final Function<ILink, MeasurementPath> associationTransform = new Function<ILink, MeasurementPath>(){

        public MeasurementPath apply(ILink input) {
            return new MeasurementPath((Measurement)Measurement.LINK_TO_MEASUREMENT_TRANSFORM.apply((Object)input));
        }
    };
    private BufferedImage image;
    private Observation observation;
    private boolean selectedLineEnd;
    private boolean selectedLineStart;
    private final ToolBelt toolBelt;

    public MeasurementLayerUI(ToolBelt toolBelt, CommonPainters<T> commonPainters) {
        super(commonPainters);
        this.setDisplayName("Distance");
        this.setSettingsBuilder(new MeasurementLayerSettingsBuilder(this, toolBelt.getAnnotationPersistenceService()));
        this.toolBelt = toolBelt;
        this.addPainter(this.selectedObservationPainter);
        AnnotationProcessor.process((Object)((Object)this));
    }

    public void addMeasurementCompletedListener(MeasurementCompletedListener listener) {
        this.measurementCompletedListeners.add(listener);
    }

    @Override
    public void clearPainters() {
        super.clearPainters();
        this.addPainter(this.selectedObservationPainter);
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    private Measurement newMeasurement(String comment, JXLayer<? extends T> jxl) {
        int x0 = (int)Math.round(this.lineStart.getX());
        int y0 = (int)Math.round(this.lineStart.getY());
        int x1 = (int)Math.round(this.lineEnd.getX());
        int y1 = (int)Math.round(this.lineEnd.getY());
        return new Measurement(x0, y0, x1, y1, comment);
    }

    @Override
    protected void paintLayer(Graphics2D g2, JXLayer<? extends T> jxl) {
        super.paintLayer(g2, jxl);
        g2.setPaintMode();
        g2.setPaint(Color.GREEN);
        g2.setStroke(new BasicStroke(2.0f));
        for (MeasurementPath path : this.measurementPaths) {
            try {
                this.updateMeasurementPath(path, jxl);
                String comment = path.measurement.getComment();
                g2.draw(path.generalPath);
                g2.setFont(this.lineFont);
                g2.drawString(comment, (float)path.commentPoint.getX(), (float)path.commentPoint.getY());
            }
            catch (Exception e) {
                this.log.warn("Problem with drawing measurement path", (Throwable)e);
            }
        }
        g2.setPaintMode();
        g2.setStroke(new BasicStroke(2.0f));
        g2.setPaint(Color.RED);
        int markerOffset = 5;
        if (this.selectedLineStart) {
            Point2D lineStartPoint = ((JImageUrlCanvas)jxl.getView()).convertToComponent(this.lineStart);
            Point componentPoint = AwtUtilities.toPoint((Point2D)lineStartPoint);
            int x = componentPoint.x;
            int y = componentPoint.y;
            Ellipse2D.Double marker = new Ellipse2D.Double(x - 5, y - 5, 10.0, 10.0);
            g2.draw(marker);
            g2.draw(this.line);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent me, JXLayer<? extends T> jxl) {
        super.processMouseEvent(me, jxl);
        Point point = SwingUtilities.convertPoint(me.getComponent(), me.getPoint(), jxl);
        switch (me.getID()) {
            case 501: {
                Point2D imagePoint = ((JImageUrlCanvas)jxl.getView()).convertToImage((Point2D)point);
                if (imagePoint == null || this.image == null) break;
                int x = (int)Math.round(imagePoint.getX());
                int y = (int)Math.round(imagePoint.getY());
                if (x < 0) {
                    x = 0;
                }
                if (x > this.image.getWidth()) {
                    x = this.image.getWidth();
                }
                if (y < 0) {
                    y = 0;
                }
                if (y > this.image.getHeight()) {
                    y = this.image.getHeight();
                }
                imagePoint.setLocation(x, y);
                if (!this.selectedLineStart) {
                    this.lineStart.setLocation(imagePoint);
                    this.selectedLineStart = true;
                    this.setDirty(true);
                    break;
                }
                this.lineEnd.setLocation(imagePoint);
                this.selectedLineEnd = true;
                Measurement measurement = this.newMeasurement(null, jxl);
                this.setDirty(true);
                MeasurementCompletedEvent event = new MeasurementCompletedEvent(measurement, this.observation);
                for (MeasurementCompletedListener listener : this.measurementCompletedListeners) {
                    listener.onComplete(event);
                }
                this.resetUI();
            }
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent me, JXLayer<? extends T> jxl) {
        super.processMouseMotionEvent(me, jxl);
        if (me.getID() == 503 && this.selectedLineStart && !this.selectedLineEnd) {
            Point point = SwingUtilities.convertPoint(me.getComponent(), me.getPoint(), jxl);
            int w = jxl.getWidth();
            int h = jxl.getHeight();
            this.line.reset();
            if (point.y <= h && point.x <= w) {
                Point2D componentPoint = ((JImageUrlCanvas)jxl.getView()).convertToComponent(this.lineStart);
                this.line.moveTo(componentPoint.getX(), componentPoint.getY());
                this.line.lineTo(point.x, point.y);
            }
            this.setDirty(true);
        }
    }

    @Override
    public void resetUI() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.resetRunable.run();
        } else {
            SwingUtilities.invokeLater(this.resetRunable);
        }
    }

    @EventSubscriber(eventClass=IAFRepaintEvent.class)
    public void respondsTo(IAFRepaintEvent event) {
        UIDataCoordinator dataCoordinator = (UIDataCoordinator)event.get();
        Observation obs = dataCoordinator.getSelectedObservations().size() == 1 ? dataCoordinator.getSelectedObservations().iterator().next() : null;
        this.setObservation(obs);
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public void setObservation(Observation newObservation) {
        Observation oldObservation = this.observation;
        this.observation = newObservation;
        this.measurementPaths.clear();
        if (this.observation != null) {
            Collection associations = Collections2.filter((Collection)this.observation.getAssociations(), Measurement.IS_MEASUREMENT_PREDICATE);
            for (Association association : associations) {
                try {
                    this.measurementPaths.add((MeasurementPath)this.associationTransform.apply((Object)association));
                }
                catch (Exception e) {
                    this.log.warn("Unable to parse coordinates from the association, " + association);
                }
            }
        }
        this.resetUI();
        this.propertyChangeSupport.firePropertyChange(PROP_OBSERVATION, oldObservation, this.observation);
    }

    private void updateMeasurementPath(MeasurementPath measurementPath, JXLayer<? extends T> jxl) {
        Measurement measurement = measurementPath.measurement;
        GeneralPath generalPath = measurementPath.generalPath;
        generalPath.reset();
        Point2D.Double imagePoint0 = new Point2D.Double(measurement.getX0(), measurement.getY0());
        Point2D componentPoint2D0 = ((JImageUrlCanvas)jxl.getView()).convertToComponent((Point2D)imagePoint0);
        generalPath.moveTo(componentPoint2D0.getX(), componentPoint2D0.getY());
        Point2D.Double imagePoint1 = new Point2D.Double(measurement.getX1(), measurement.getY1());
        Point2D componentPoint2D1 = ((JImageUrlCanvas)jxl.getView()).convertToComponent((Point2D)imagePoint1);
        generalPath.lineTo(componentPoint2D1.getX(), componentPoint2D1.getY());
        double cx = (componentPoint2D0.getX() + componentPoint2D1.getX()) / 2.0 + 5.0;
        double cy = (componentPoint2D0.getY() + componentPoint2D1.getY()) / 2.0;
        measurementPath.commentPoint.setLocation(cx, cy);
    }

    class MeasurementPath {
        final GeneralPath generalPath = new GeneralPath();
        final Point2D commentPoint = new Point2D.Float();
        final Measurement measurement;

        MeasurementPath(Measurement measurement) {
            this.measurement = measurement;
        }
    }
}

