/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.imagepanel;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import org.mbari.swing.JImageUrlCanvas;
import vars.annotation.AnnotationPersistenceService;
import vars.annotation.ui.imagepanel.IMarkerStyle;
import vars.annotation.ui.imagepanel.JXIdentityReferencePainter;
import vars.annotation.ui.imagepanel.JXNotSelectedObservationsPainter;
import vars.annotation.ui.imagepanel.JXObservationsPainter;
import vars.annotation.ui.imagepanel.MarkerStyle;
import vars.annotation.ui.imagepanel.MarkerStyleBean;
import vars.annotation.ui.imagepanel.MultiLayerUI;
import vars.annotation.ui.imagepanel.UISettingsBuilder;

public class MeasurementLayerSettingsBuilder<T extends JImageUrlCanvas>
implements UISettingsBuilder {
    private final JXObservationsPainter<T> identityReferencePainter;
    private final MultiLayerUI<T> layerUI;
    private final JXObservationsPainter<T> notSelectedObservationsPainter;
    private final JPanel panel;
    private JCheckBox showNotSelectedCheckBox;
    private JCheckBox showPainterCheckBox;
    private JButton showColorChooserButton;

    public MeasurementLayerSettingsBuilder(MultiLayerUI<T> layerUI, AnnotationPersistenceService annotationPersistenceService) {
        this.layerUI = layerUI;
        this.identityReferencePainter = new JXIdentityReferencePainter(annotationPersistenceService);
        this.notSelectedObservationsPainter = new JXNotSelectedObservationsPainter(MarkerStyle.NOTSELECTED_FAINT);
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 0));
        layerUI.addPainter(this.notSelectedObservationsPainter);
        this.panel.add(this.getShowNotSelectedCheckBox());
        this.panel.add(Box.createHorizontalStrut(20));
        this.panel.add(this.getShowPainterCheckBox());
        this.panel.add(this.getShowColorChooserButton());
    }

    protected JCheckBox getShowPainterCheckBox() {
        if (this.showPainterCheckBox == null) {
            this.showPainterCheckBox = new JCheckBox();
            this.showPainterCheckBox.setText("Show Related Observations");
            this.showPainterCheckBox.setSelected(false);
            this.showPainterCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (MeasurementLayerSettingsBuilder.this.showPainterCheckBox.isSelected()) {
                        MeasurementLayerSettingsBuilder.this.layerUI.addPainter(MeasurementLayerSettingsBuilder.this.identityReferencePainter);
                    } else {
                        MeasurementLayerSettingsBuilder.this.layerUI.removePainter(MeasurementLayerSettingsBuilder.this.identityReferencePainter);
                    }
                }
            });
            this.showPainterCheckBox.setSelected(false);
            this.showPainterCheckBox.setToolTipText("Shows observations with the same identity-reference from other videoframes");
        }
        return this.showPainterCheckBox;
    }

    protected JCheckBox getShowNotSelectedCheckBox() {
        if (this.showNotSelectedCheckBox == null) {
            this.showNotSelectedCheckBox = new JCheckBox();
            this.showNotSelectedCheckBox.setText("Show Observations in Same Video Frame");
            this.showNotSelectedCheckBox.setSelected(true);
            this.showNotSelectedCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (MeasurementLayerSettingsBuilder.this.showNotSelectedCheckBox.isSelected()) {
                        MeasurementLayerSettingsBuilder.this.layerUI.addPainter(MeasurementLayerSettingsBuilder.this.notSelectedObservationsPainter);
                    } else {
                        MeasurementLayerSettingsBuilder.this.layerUI.removePainter(MeasurementLayerSettingsBuilder.this.notSelectedObservationsPainter);
                    }
                    MeasurementLayerSettingsBuilder.this.getShowColorChooserButton().setEnabled(MeasurementLayerSettingsBuilder.this.showNotSelectedCheckBox.isSelected());
                }
            });
        }
        return this.showNotSelectedCheckBox;
    }

    protected JButton getShowColorChooserButton() {
        if (this.showColorChooserButton == null) {
            this.showColorChooserButton = new JButton("Select Color");
            this.showColorChooserButton.setToolTipText("Select related observations color");
            this.showColorChooserButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IMarkerStyle markerStyle = MeasurementLayerSettingsBuilder.this.identityReferencePainter.getMarkerStyle();
                    Color color = JColorChooser.showDialog(MeasurementLayerSettingsBuilder.this.panel, "Choose related observations color", markerStyle.getColor());
                    markerStyle = new MarkerStyleBean(color, markerStyle.getArmLength(), markerStyle.getFont(), markerStyle.getStroke());
                    MeasurementLayerSettingsBuilder.this.identityReferencePainter.setMarkerStyle(markerStyle);
                }
            });
        }
        return this.showColorChooserButton;
    }

    @Override
    public void clearPainters() {
        if (this.getShowPainterCheckBox().isSelected()) {
            this.layerUI.addPainter(this.identityReferencePainter);
        } else {
            this.layerUI.removePainter(this.identityReferencePainter);
        }
        if (this.showNotSelectedCheckBox.isSelected()) {
            this.layerUI.addPainter(this.notSelectedObservationsPainter);
        } else {
            this.layerUI.removePainter(this.notSelectedObservationsPainter);
        }
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }
}

