/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.ui.imagepanel;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import vars.ILink;
import vars.LinkBean;
import vars.annotation.Association;
import vars.annotation.Observation;

public class Measurement {
    public static final String MEASUREMENT_LINKNAME = "measurement in pixels [x0 y0 x1 y1 comment]";
    public static final Function<ILink, Measurement> LINK_TO_MEASUREMENT_TRANSFORM = new Function<ILink, Measurement>(){

        public Measurement apply(ILink input) {
            return Measurement.fromLink(input);
        }
    };
    public static final Predicate<Association> IS_MEASUREMENT_PREDICATE = new Predicate<Association>(){

        public boolean apply(Association input) {
            return Measurement.MEASUREMENT_LINKNAME.equalsIgnoreCase(input.getLinkName());
        }
    };
    private String comment;
    private final int x0;
    private final int x1;
    private final int y0;
    private final int y1;

    public Measurement(int x0, int y0, int x1, int y1) {
        this(x0, y0, x1, y1, null);
    }

    public Measurement(int x0, int y0, int x1, int y1, String comment) {
        this.x0 = x0;
        this.y0 = y0;
        this.x1 = x1;
        this.y1 = y1;
        this.comment = comment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Measurement that = (Measurement)o;
        if (this.x0 != that.x0) {
            return false;
        }
        if (this.x1 != that.x1) {
            return false;
        }
        if (this.y0 != that.y0) {
            return false;
        }
        return this.y1 == that.y1;
    }

    public static Measurement fromLink(ILink link) {
        String[] parts = link.getLinkValue().split(" ");
        if (parts.length < 4) {
            throw new IllegalArgumentException("The Association does not contain 2 pixel coordinates");
        }
        Integer x0 = Integer.valueOf(parts[0]);
        Integer y0 = Integer.valueOf(parts[1]);
        Integer x1 = Integer.valueOf(parts[2]);
        Integer y1 = Integer.valueOf(parts[3]);
        int idx = parts[0].length() + parts[1].length() + parts[2].length() + parts[3].length() + 4;
        String comment = link.getLinkValue().substring(idx);
        return new Measurement(x0, y0, x1, y1, comment);
    }

    public static Collection<Measurement> fromObservation(Observation observation) {
        Collection associations = Collections2.filter((Collection)observation.getAssociations(), IS_MEASUREMENT_PREDICATE);
        Collection measurements = Collections2.transform((Collection)associations, LINK_TO_MEASUREMENT_TRANSFORM);
        return new ArrayList<Measurement>(measurements);
    }

    public String getComment() {
        return this.comment;
    }

    public int getX0() {
        return this.x0;
    }

    public int getX1() {
        return this.x1;
    }

    public int getY0() {
        return this.y0;
    }

    public int getY1() {
        return this.y1;
    }

    public int hashCode() {
        int result = this.x0;
        result = 31 * result + this.y0;
        result = 31 * result + this.x1;
        result = 31 * result + this.y1;
        return result;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public ILink toLink() {
        String c = "";
        if (this.comment != null && !this.comment.isEmpty()) {
            c = " " + this.comment;
        }
        return new LinkBean(MEASUREMENT_LINKNAME, "self", this.x0 + " " + this.y0 + " " + this.x1 + " " + this.y1 + c);
    }

    public String toString() {
        return "Measurement{x0=" + this.x0 + ", y0=" + this.y0 + ", x1=" + this.x1 + ", y1=" + this.y1 + '}';
    }
}

